/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import io.swagger.models.refs.RefType;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.processors.ExternalRefProcessor;
import io.swagger.parser.processors.PropertyProcessor;
import io.swagger.parser.util.RefUtils;
import java.util.List;
import java.util.Map;

public class ModelProcessor {
    private final PropertyProcessor propertyProcessor;
    private final ExternalRefProcessor externalRefProcessor;

    public ModelProcessor(ResolverCache cache, Swagger swagger) {
        this.propertyProcessor = new PropertyProcessor(cache, swagger);
        this.externalRefProcessor = new ExternalRefProcessor(cache, swagger);
    }

    public void processModel(Model model) {
        if (model == null) {
            return;
        }
        if (model instanceof RefModel) {
            this.processRefModel((RefModel)model);
        } else if (model instanceof ArrayModel) {
            this.processArrayModel((ArrayModel)model);
        } else if (model instanceof ComposedModel) {
            this.processComposedModel((ComposedModel)model);
        } else if (model instanceof ModelImpl) {
            this.processModelProperties(model);
        }
    }

    private void processModelProperties(Model model) {
        Map properties = model.getProperties();
        if (properties == null) {
            return;
        }
        for (Map.Entry propertyEntry : properties.entrySet()) {
            Property property = (Property)propertyEntry.getValue();
            this.propertyProcessor.processProperty(property);
        }
    }

    private void processComposedModel(ComposedModel composedModel) {
        this.processModel(composedModel.getParent());
        this.processModel(composedModel.getChild());
        List interfaces = composedModel.getInterfaces();
        if (interfaces != null) {
            for (RefModel model : interfaces) {
                this.processRefModel(model);
            }
        }
        this.processModelProperties((Model)composedModel);
    }

    private void processArrayModel(ArrayModel arrayModel) {
        Property items = arrayModel.getItems();
        if (items != null) {
            this.propertyProcessor.processProperty(items);
        }
    }

    private void processRefModel(RefModel refModel) {
        String newRef = null;
        if (RefUtils.isAnExternalRefFormat(refModel.getRefFormat())) {
            newRef = this.externalRefProcessor.processRefToExternalDefinition(refModel.get$ref(), refModel.getRefFormat());
        }
        if (newRef != null) {
            refModel.set$ref(RefType.DEFINITION.getInternalPrefix() + newRef);
        }
    }
}

