/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.lifecycle.profiler;

import io.tesla.lifecycle.profiler.MojoProfile;
import io.tesla.lifecycle.profiler.PhaseProfile;
import io.tesla.lifecycle.profiler.ProjectProfile;
import io.tesla.lifecycle.profiler.SessionProfile;
import io.tesla.lifecycle.profiler.SessionProfileRenderer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.ExecutionEvent;

@Named
@Singleton
public class LifecycleProfiler
extends AbstractEventSpy {
    private static final String TESLA_PROFILE = "maven.profile";
    private SessionProfileRenderer renderer;
    private SessionProfile sessionProfile;
    private ProjectProfile projectProfile;
    private PhaseProfile phaseProfile;
    private MojoProfile mojoProfile;

    @Inject
    public LifecycleProfiler(SessionProfileRenderer sessionProfileRenderer) {
        this.renderer = sessionProfileRenderer;
    }

    public void init(EventSpy.Context context) throws Exception {
    }

    public void onEvent(Object event) throws Exception {
        if (event instanceof ExecutionEvent) {
            ExecutionEvent executionEvent = (ExecutionEvent)event;
            if (executionEvent.getType() == ExecutionEvent.Type.SessionStarted) {
                this.sessionProfile = new SessionProfile();
            } else if (executionEvent.getType() == ExecutionEvent.Type.SessionEnded) {
                this.sessionProfile.stop();
                if (System.getProperty(TESLA_PROFILE) != null) {
                    this.renderer.render(this.sessionProfile);
                }
            } else if (executionEvent.getType() == ExecutionEvent.Type.ProjectStarted) {
                this.projectProfile = new ProjectProfile(executionEvent.getProject());
            } else if (executionEvent.getType() == ExecutionEvent.Type.ProjectSucceeded || executionEvent.getType() == ExecutionEvent.Type.ProjectFailed) {
                this.projectProfile.stop();
                this.sessionProfile.addProjectProfile(this.projectProfile);
            } else if (executionEvent.getType() == ExecutionEvent.Type.MojoStarted) {
                String phase = executionEvent.getMojoExecution().getLifecyclePhase();
                if (this.phaseProfile == null) {
                    this.phaseProfile = new PhaseProfile(phase);
                } else if (!this.phaseProfile.getPhase().equals(phase)) {
                    this.phaseProfile.stop();
                    this.projectProfile.addPhaseProfile(this.phaseProfile);
                    this.phaseProfile = new PhaseProfile(phase);
                }
                this.mojoProfile = new MojoProfile(executionEvent.getMojoExecution());
            } else if (executionEvent.getType() == ExecutionEvent.Type.MojoSucceeded || executionEvent.getType() == ExecutionEvent.Type.MojoFailed) {
                this.mojoProfile.stop();
                this.phaseProfile.addMojoProfile(this.mojoProfile);
            }
        }
    }
}

