/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.lifecycle.profiler.internal;

import io.tesla.lifecycle.profiler.Timer;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class DefaultTimer
implements Timer {
    public static final int MS_PER_SEC = 1000;
    public static final int SEC_PER_MIN = 60;
    private long start = System.currentTimeMillis();
    private long time;

    @Override
    public void stop() {
        this.time = this.elapsedTime();
    }

    @Override
    public long getTime() {
        return this.time;
    }

    private long elapsedTime() {
        return System.currentTimeMillis() - this.start;
    }

    @Override
    public String format(long ms) {
        long secs = ms / 1000L;
        long mins = secs / 60L;
        long fractionOfASecond = ms - (secs %= 60L) * 1000L;
        StringBuilder msg = new StringBuilder();
        if (mins > 0L) {
            msg.append(mins);
            msg.append("m ");
        }
        if (secs > 0L) {
            msg.append(secs);
            msg.append("s");
        }
        if (mins == 0L) {
            if (msg.length() > 0) {
                msg.append(" ");
            }
            msg.append(fractionOfASecond);
            msg.append("ms");
        }
        return msg.toString();
    }
}

