/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.logging.jul;

import io.yupiik.logging.jul.formatter.InlineFormatter;
import io.yupiik.logging.jul.formatter.JsonFormatter;
import io.yupiik.logging.jul.formatter.PatternFormatter;
import io.yupiik.logging.jul.handler.AsyncHandler;
import io.yupiik.logging.jul.handler.LocalFileHandler;
import io.yupiik.logging.jul.handler.StandardHandler;
import io.yupiik.logging.jul.handler.StdoutHandler;
import io.yupiik.logging.jul.logger.YupiikLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class YupiikLoggers {
    private final Pattern posix = Pattern.compile("[^A-Za-z0-9]");
    private State state = new State();

    public synchronized void close() {
        if (this.state.shutdownHook != null) {
            this.state.shutdownHook.run();
            this.state.shutdownHook = null;
        }
    }

    public boolean addLogger(Logger logger) {
        if (!YupiikLogger.class.isInstance(logger)) {
            this.state.loggers.putIfAbsent(logger.getName(), this.createLogger(logger.getName(), logger.getResourceBundleName(), logger.getResourceBundle()));
            return false;
        }
        return this.state.loggers.putIfAbsent(logger.getName(), (YupiikLogger)YupiikLogger.class.cast(logger)) == null;
    }

    public Logger getLogger(String name, String bundle) {
        YupiikLogger logger = this.getLoggerOrNull(name);
        if (logger != null) {
            return logger;
        }
        YupiikLogger newInstance = this.createLogger(name, bundle, null);
        YupiikLogger existing = this.state.loggers.putIfAbsent(name, newInstance);
        if (existing != null) {
            return existing;
        }
        return newInstance;
    }

    public YupiikLogger getLoggerOrNull(String name) {
        return (YupiikLogger)this.state.loggers.get(name);
    }

    public String getProperty(String name) {
        return Optional.ofNullable(System.getProperty(name)).or(() -> Optional.ofNullable(System.getenv(this.posix.matcher(name).replaceAll("_").toUpperCase(Locale.ROOT)))).orElseGet(() -> (String)this.state.configuration.get(name));
    }

    public Enumeration<String> getLoggerNames() {
        return Collections.enumeration(this.state.loggers.keySet());
    }

    public void reset() throws SecurityException {
        this.state = new State();
    }

    public synchronized void readConfiguration() throws IOException, SecurityException {
        Thread hook;
        if (!this.state.configurationRead.compareAndSet(false, true)) {
            return;
        }
        this.state.shutdownHook = hook = new Thread(() -> this.state.loggers.values().stream().flatMap(it -> Stream.of(it.getHandlers())).distinct().forEach(it -> {
            try {
                it.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }), this.getClass().getName() + "-shutdown");
        try {
            Runtime.getRuntime().addShutdownHook(hook);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        String location = this.getProperty("java.util.logging.config.file");
        if (location != null) {
            Path path = Paths.get(location, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                this.readConfiguration(Files.newInputStream(path, new OpenOption[0]));
                return;
            }
            InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
            if (resource != null) {
                this.readConfiguration(resource);
                return;
            }
        }
        String level = this.getProperty(".level");
        String handlers = this.getProperty(".handlers");
        this.readConfiguration(new ByteArrayInputStream((".level=" + (level == null || level.isBlank() ? "INFO" : level) + "\n.handlers=" + (handlers == null || handlers.isBlank() ? "io.yupiik.logging.jul.handler.AsyncHandler" : handlers) + "\n").getBytes(StandardCharsets.UTF_8)));
    }

    public void readConfiguration(InputStream inputStream) throws IOException, SecurityException {
        Properties properties = new Properties();
        try (InputStream stream = inputStream;){
            properties.load(stream);
        }
        Map newConfig = properties.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), properties::getProperty));
        if (!newConfig.equals(this.state.configuration)) {
            this.state.configuration.clear();
            this.state.configuration.putAll(newConfig);
        }
        this.invokeListeners();
    }

    public void updateConfiguration(Function<String, BiFunction<String, String, String>> mapper) {
        for (Map.Entry entry : new ArrayList(this.state.configuration.entrySet())) {
            BiFunction<String, String, String> kvMapper = mapper.apply((String)entry.getKey());
            String newValue = kvMapper.apply(null, (String)entry.getValue());
            if (newValue == null) {
                this.state.configuration.remove(entry.getKey());
                continue;
            }
            this.state.configuration.put((String)entry.getKey(), newValue);
        }
        this.invokeListeners();
    }

    private void invokeListeners() {
        if (this.state.listeners.isEmpty()) {
            return;
        }
        Throwable firstError = null;
        for (Runnable c : this.state.listeners.values()) {
            try {
                c.run();
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Error | RuntimeException x) {
                if (firstError == null) {
                    firstError = x;
                    continue;
                }
                firstError.addSuppressed(x);
            }
        }
        if (Error.class.isInstance(firstError)) {
            throw (Error)Error.class.cast(firstError);
        }
        if (RuntimeException.class.isInstance(firstError)) {
            throw (RuntimeException)RuntimeException.class.cast(firstError);
        }
    }

    public void addConfigurationListener(Runnable listener) {
        this.state.listeners.put(listener, listener);
    }

    public void removeConfigurationListener(Runnable listener) {
        this.state.listeners.remove(listener);
    }

    private YupiikLogger createLogger(String name, String bundle, ResourceBundle resourceBundle) {
        int dot;
        try {
            this.readConfiguration();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        YupiikLogger logger = new YupiikLogger(name, bundle, resourceBundle);
        this.configure(logger);
        Logger current = logger;
        while (current.getParent() == null && (dot = current.getName().lastIndexOf(46)) >= 0) {
            Logger parent = this.getLogger(current.getName().substring(0, dot), null);
            logger.setParent(parent);
            current = parent;
        }
        if (!name.isEmpty() && current.getParent() == null) {
            logger.setParent(this.getLogger("", null));
        }
        return logger;
    }

    private void configure(YupiikLogger logger) {
        String handlers;
        String level = this.getPropertyOrParentValue(logger.getName(), ".level");
        logger.setLevel(level == null ? Level.INFO : Level.parse(level));
        String useParents = this.getProperty(logger.getName() + ".useParentHandlers");
        logger.setUseParentHandlers(useParents == null || Boolean.parseBoolean(useParents));
        String filter = this.getProperty(logger.getName() + ".filter");
        if (filter != null) {
            try {
                logger.setFilter(Thread.currentThread().getContextClassLoader().loadClass(filter.trim()).asSubclass(Filter.class).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if ((handlers = this.getProperty(logger.getName() + ".handlers")) != null) {
            if (logger.getHandlers().length > 0) {
                Stream.of(logger.getHandlers()).forEach(logger::removeHandler);
            }
            Stream.of(handlers.split(",")).map(String::trim).filter(it -> !it.isEmpty()).map(this::createHandler).forEach(logger::addHandler);
        }
    }

    private String getPropertyOrParentValue(String name, String sub) {
        int sep;
        String current = name;
        do {
            String value;
            if ((value = this.getProperty(current + sub)) == null) continue;
            return value;
        } while (!(current = (sep = current.lastIndexOf(46)) > 0 ? current.substring(0, sep) : "").isEmpty());
        return this.getProperty(sub);
    }

    private Handler createHandler(String handlerType) {
        String level;
        String filter;
        Handler handler = this.newHandler(handlerType);
        String formatter = this.getProperty(handlerType + ".formatter");
        if (formatter != null) {
            switch (formatter.trim().toLowerCase(Locale.ROOT)) {
                case "pattern": {
                    handler.setFormatter(new PatternFormatter(this.getProperty(PatternFormatter.class.getName() + ".pattern")));
                    break;
                }
                case "inline": {
                    handler.setFormatter(new InlineFormatter());
                    break;
                }
                case "json": {
                    handler.setFormatter(new JsonFormatter());
                    break;
                }
                default: {
                    if (formatter.startsWith("pattern(") && formatter.endsWith(")")) {
                        handler.setFormatter(new PatternFormatter(formatter.substring("pattern(".length(), formatter.length() - 1)));
                        break;
                    }
                    if (formatter.startsWith("json(") && formatter.endsWith(")")) {
                        String conf = formatter.substring("json(".length(), formatter.length() - 1);
                        Map<String, String> config = Stream.of(conf.split(";")).map(it -> it.split("=")).collect(Collectors.toMap(it -> it[0], it -> it[1]));
                        JsonFormatter jsonFormatter = new JsonFormatter();
                        jsonFormatter.setUseUUID(Boolean.parseBoolean(config.get("useUUID")));
                        jsonFormatter.setFormatMessage(Boolean.parseBoolean(config.get("formatMessage")));
                        Optional.ofNullable(config.get("customEntriesMapper")).ifPresent(clazz -> {
                            try {
                                jsonFormatter.setCustomEntriesMapper(Thread.currentThread().getContextClassLoader().loadClass(clazz.trim()).asSubclass(Function.class).getConstructor(new Class[0]).newInstance(new Object[0]));
                            }
                            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                                throw new IllegalArgumentException(e);
                            }
                        });
                        handler.setFormatter(jsonFormatter);
                        break;
                    }
                    try {
                        handler.setFormatter(Thread.currentThread().getContextClassLoader().loadClass(formatter.trim()).asSubclass(Formatter.class).getConstructor(new Class[0]).newInstance(new Object[0]));
                        break;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                }
            }
        } else {
            handler.setFormatter(new InlineFormatter());
        }
        String encoding = this.getProperty(handlerType + ".encoding");
        if (encoding != null) {
            try {
                handler.setEncoding(encoding);
            }
            catch (UnsupportedEncodingException e) {
                try {
                    handler.setEncoding(StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e2) {
                    // empty catch block
                }
            }
        }
        if ((filter = this.getProperty(handlerType + ".filter")) != null) {
            try {
                handler.setFilter(Thread.currentThread().getContextClassLoader().loadClass(filter.trim()).asSubclass(Filter.class).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if ((level = this.getProperty(handlerType + ".level")) != null) {
            handler.setLevel(Level.parse(level));
        }
        return handler;
    }

    private Handler newHandler(String it) {
        switch (it) {
            case "async": 
            case "io.yupiik.logging.jul.handler.AsyncHandler": {
                return new AsyncHandler();
            }
            case "std": 
            case "standard": 
            case "io.yupiik.logging.jul.handler.StandardHandler": {
                return new StandardHandler();
            }
            case "stdout": 
            case "io.yupiik.logging.jul.handler.StdoutHandler": {
                return new StdoutHandler();
            }
            case "file": 
            case "local": 
            case "io.yupiik.logging.jul.handler.LocalFileHandler": {
                return new LocalFileHandler(){

                    @Override
                    protected <T> T getProperty(String name, Function<String, T> mapper, Supplier<T> defaultValue) {
                        return Optional.ofNullable(YupiikLoggers.this.getProperty(name)).map(mapper).orElseGet(defaultValue);
                    }
                };
            }
        }
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(it.trim()).asSubclass(Handler.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class State {
        private final ConcurrentMap<Runnable, Runnable> listeners = new ConcurrentHashMap<Runnable, Runnable>();
        private final ConcurrentMap<String, YupiikLogger> loggers = new ConcurrentHashMap<String, YupiikLogger>();
        private final ConcurrentMap<String, String> configuration = new ConcurrentHashMap<String, String>();
        private final AtomicBoolean configurationRead = new AtomicBoolean(false);
        private volatile Thread shutdownHook;

        private State() {
        }
    }
}

