/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.logging.jul.formatter;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class InlineFormatter
extends Formatter {
    private final DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 3, 3, true).parseLenient().appendOffsetId().parseStrict().toFormatter();

    @Override
    public String format(LogRecord record) {
        return record.getInstant().atOffset(ZoneOffset.UTC).format(this.formatter) + " [" + record.getLevel().getName() + "][" + record.getLoggerName() + "] " + this.formatMessage(record) + this.toString(record.getThrown()) + "\n";
    }

    private String toString(Throwable thrown) {
        if (thrown == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(writer);){
            thrown.printStackTrace(printWriter);
        }
        return "\n" + writer.toString().trim();
    }
}

