/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.logging.jul.formatter;

import io.yupiik.logging.jul.formatter.JsonStrings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class JsonFormatter
extends Formatter {
    private static final ZoneId UTC = ZoneId.of("UTC");
    private boolean useUUID;
    private boolean formatMessage = true;
    private Function<LogRecord, Map<String, String>> customEntriesMapper = null;

    public void setCustomEntriesMapper(Function<LogRecord, Map<String, String>> customEntriesMapper) {
        this.customEntriesMapper = customEntriesMapper;
    }

    public void setFormatMessage(boolean formatMessage) {
        this.formatMessage = formatMessage;
    }

    public void setUseUUID(boolean useUUID) {
        this.useUUID = useUUID;
    }

    @Override
    public String format(LogRecord record) {
        Map<String, String> data;
        String message;
        StringBuilder json = new StringBuilder("{");
        if (this.useUUID) {
            json.append("\"uuid\":\"").append(UUID.randomUUID()).append("\",");
        }
        json.append("\"timestamp\":").append(this.escape(OffsetDateTime.ofInstant(Instant.ofEpochMilli(record.getMillis()), UTC).toString()));
        if (record.getLevel() != null) {
            json.append(",\"level\":\"").append(record.getLevel().getName()).append("\"");
        }
        if (record.getLoggerName() != null) {
            json.append(",\"logger\":\"").append(record.getLoggerName()).append("\"");
        }
        if (record.getSourceMethodName() != null) {
            json.append(",\"method\":\"").append(record.getSourceMethodName()).append("\"");
        }
        String string = message = this.formatMessage ? this.formatMessage(record) : record.getMessage();
        if (message != null) {
            json.append(",\"message\":").append(this.escape(message));
        }
        if (record.getThrown() != null) {
            json.append(",\"exception\":").append(this.escape(this.toString(record.getThrown())));
        }
        if (record.getSourceClassName() != null) {
            json.append(",\"class\":\"").append(record.getSourceClassName()).append("\"");
        }
        if (this.customEntriesMapper != null && (data = this.customEntriesMapper.apply(record)) != null) {
            data.forEach((k, v) -> json.append(",\"").append((String)k).append("\":").append((String)v));
        }
        return json.append('}').toString() + "\n";
    }

    protected String escape(String value) {
        return JsonStrings.escape(value);
    }

    protected String toString(Throwable thrown) {
        StringWriter w = new StringWriter();
        try (PrintWriter writer = new PrintWriter(w);){
            thrown.printStackTrace(writer);
        }
        return w.toString();
    }
}

