/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.logging.jul.formatter;

final class JsonStrings {
    private JsonStrings() {
    }

    static String escape(String value) {
        StringBuilder sb = new StringBuilder(value.length());
        sb.append('\"');
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (JsonStrings.isPassthrough(c)) {
                sb.append(c);
                continue;
            }
            sb.append(JsonStrings.escape(c));
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String escape(char c) {
        if (JsonStrings.isPassthrough(c)) {
            return String.valueOf(c);
        }
        switch (c) {
            case '\"': 
            case '\\': {
                return "\\" + c;
            }
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        String hex = "000" + Integer.toHexString(c);
        return "\\u" + hex.substring(hex.length() - 4);
    }

    private static boolean isPassthrough(char c) {
        return c >= ' ' && c != '\"' && c != '\\';
    }
}

