/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.logging.jul.formatter;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.stream.Collectors;

public class PatternFormatter
extends Formatter {
    private final Collection<Item> items;

    public PatternFormatter(String pattern) {
        this.items = PatternFormatter.parse(pattern);
    }

    @Override
    public String format(LogRecord record) {
        return this.items.stream().map(i -> i.extract(this, record)).collect(Collectors.joining());
    }

    private static Collection<Item> parse(String pattern) {
        ArrayList<Item> items = new ArrayList<Item>();
        StringBuilder builder = new StringBuilder();
        block19: for (int i = 0; i < pattern.length(); ++i) {
            char current = pattern.charAt(i);
            switch (current) {
                case '%': {
                    char marker = pattern.charAt(i + 1);
                    switch (marker) {
                        case 'r': {
                            ++i;
                            PatternFormatter.flushBuilder(items, builder);
                            items.add(new DurationSinceStartup());
                            continue block19;
                        }
                        case 'n': {
                            ++i;
                            PatternFormatter.flushBuilder(items, builder);
                            items.add(new Constant("\n"));
                            continue block19;
                        }
                        case 'C': {
                            ++i;
                            PatternFormatter.flushBuilder(items, builder);
                            items.add(new ClassName());
                            continue block19;
                        }
                        case 'M': {
                            ++i;
                            PatternFormatter.flushBuilder(items, builder);
                            items.add(new MethodName());
                            continue block19;
                        }
                        case 'l': {
                            PatternFormatter.flushBuilder(items, builder);
                            if (pattern.substring(++i).startsWith("logger")) {
                                items.add(new LoggerName());
                                i += "logger".length() - 1;
                                continue block19;
                            }
                            items.add(new Level());
                            i = PatternFormatter.eatIf("level", pattern, i);
                            continue block19;
                        }
                        case 'm': {
                            PatternFormatter.flushBuilder(items, builder);
                            if (pattern.substring(++i).startsWith("method")) {
                                items.add(new MethodName());
                                i += "method".length() - 1;
                                continue block19;
                            }
                            items.add(new Message());
                            i = PatternFormatter.eatIf("message", pattern, i);
                            continue block19;
                        }
                        case 'd': {
                            ++i;
                            PatternFormatter.flushBuilder(items, builder);
                            i = PatternFormatter.eatIf("date", pattern, i);
                            if (pattern.length() > i + 1 && pattern.charAt(i + 1) == '{') {
                                int end = pattern.indexOf(125, i);
                                items.add(new Date(DateTimeFormatter.ofPattern(pattern.substring(i + 2, end))));
                                i = end;
                                continue block19;
                            }
                            items.add(new Date(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
                            continue block19;
                        }
                        case 'c': {
                            PatternFormatter.flushBuilder(items, builder);
                            if (pattern.substring(++i).startsWith("class")) {
                                items.add(new ClassName());
                                i += "class".length() - 1;
                                continue block19;
                            }
                            items.add(new LoggerName());
                            continue block19;
                        }
                        case 'x': {
                            ++i;
                            PatternFormatter.flushBuilder(items, builder);
                            items.add(new Exception());
                            continue block19;
                        }
                        case 'T': {
                            ++i;
                            PatternFormatter.flushBuilder(items, builder);
                            items.add(new ThreadId());
                            continue block19;
                        }
                        case 't': {
                            int startThread;
                            PatternFormatter.flushBuilder(items, builder);
                            int start = ++i;
                            i = PatternFormatter.eatIf("thread", pattern, i);
                            if (i == start) {
                                items.add(new ThreadName());
                                continue block19;
                            }
                            if ((startThread = ++i) != (i = PatternFormatter.eatIf("Name", pattern, i))) {
                                items.add(new ThreadName());
                                continue block19;
                            }
                            if ((i = PatternFormatter.eatIf("Id", pattern, i)) != startThread) {
                                items.add(new ThreadId());
                                continue block19;
                            }
                            throw new IllegalArgumentException("Only %threadId or %threadName can start with %t");
                        }
                        case 'u': {
                            PatternFormatter.flushBuilder(items, builder);
                            int start = ++i;
                            i = PatternFormatter.eatIf("uuid", pattern, i);
                            if (i == start) {
                                throw new IllegalArgumentException("Only %uuid can start with %u");
                            }
                            items.add(new Uuid());
                            continue block19;
                        }
                        case 'e': {
                            PatternFormatter.flushBuilder(items, builder);
                            int start = ++i;
                            i = PatternFormatter.eatIf("exception", pattern, i);
                            if (i == start) {
                                throw new IllegalArgumentException("Only %exception can start with %e");
                            }
                            items.add(new Exception());
                            continue block19;
                        }
                        case '%': {
                            ++i;
                            builder.append(current);
                            continue block19;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported item: '%" + marker + "'");
                }
                default: {
                    builder.append(current);
                }
            }
        }
        PatternFormatter.flushBuilder(items, builder);
        return items;
    }

    private static int eatIf(String value, String pattern, int i) {
        if (pattern.substring(i).startsWith(value)) {
            return i + value.length() - 1;
        }
        return i;
    }

    private static void flushBuilder(Collection<Item> items, StringBuilder builder) {
        if (builder.length() > 0) {
            items.add(new Constant(builder.toString()));
            builder.setLength(0);
        }
    }

    private static class Date
    implements Item {
        private static final ZoneId UTC = ZoneId.of("UTC");
        private final DateTimeFormatter formatter;

        private Date(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public String extract(Formatter formatter, LogRecord record) {
            return OffsetDateTime.ofInstant(record.getInstant(), UTC).format(this.formatter);
        }
    }

    private static class Uuid
    implements Item {
        private Uuid() {
        }

        @Override
        public String extract(Formatter formatter, LogRecord record) {
            return UUID.randomUUID().toString();
        }
    }

    private static class Exception
    implements Item {
        private Exception() {
        }

        @Override
        public String extract(Formatter formatter, LogRecord record) {
            Throwable thrown = record.getThrown();
            if (thrown == null) {
                return "";
            }
            StringWriter writer = new StringWriter();
            try (PrintWriter printWriter = new PrintWriter(writer);){
                thrown.printStackTrace(printWriter);
            }
            return "\n" + writer.toString().trim();
        }
    }

    private static class Message
    implements Item {
        private Message() {
        }

        @Override
        public String extract(Formatter formatter, LogRecord record) {
            return formatter.formatMessage(record);
        }
    }

    private static class Level
    implements Item {
        private Level() {
        }

        @Override
        public String extract(Formatter formatter, LogRecord record) {
            return record.getLevel().getName();
        }
    }

    private static class ThreadName
    implements Item {
        private ThreadName() {
        }

        @Override
        public String extract(Formatter formatter, LogRecord record) {
            return Thread.currentThread().getName();
        }
    }

    private static class ThreadId
    implements Item {
        private ThreadId() {
        }

        @Override
        public String extract(Formatter formatter, LogRecord record) {
            return Integer.toString(record.getThreadID());
        }
    }

    private static class MethodName
    implements Item {
        private MethodName() {
        }

        @Override
        public String extract(Formatter formatter, LogRecord record) {
            String value = record.getSourceMethodName();
            return value == null ? "" : value;
        }
    }

    private static class ClassName
    implements Item {
        private ClassName() {
        }

        @Override
        public String extract(Formatter formatter, LogRecord record) {
            String value = record.getSourceClassName();
            return value == null ? "" : value;
        }
    }

    private static class LoggerName
    implements Item {
        private LoggerName() {
        }

        @Override
        public String extract(Formatter formatter, LogRecord record) {
            return record.getLoggerName();
        }
    }

    private static class DurationSinceStartup
    implements Item {
        private final Instant startup = Instant.now();

        private DurationSinceStartup() {
        }

        @Override
        public String extract(Formatter formatter, LogRecord record) {
            return Long.toString(Duration.between(this.startup, Instant.now()).toMillis());
        }
    }

    private static class Constant
    implements Item {
        private final String value;

        private Constant(String value) {
            this.value = value;
        }

        @Override
        public String extract(Formatter formatter, LogRecord record) {
            return this.value;
        }
    }

    private static interface Item {
        public String extract(Formatter var1, LogRecord var2);
    }
}

