/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.logging.jul.handler;

import io.yupiik.logging.jul.handler.StandardHandler;
import java.io.UnsupportedEncodingException;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class AsyncHandler
extends Handler {
    private final Handler delegate;
    private final BlockingQueue<LogRecord> queue;
    private final Worker[] workers;
    private final Integer queueSize;
    private final AtomicBoolean running = new AtomicBoolean(true);

    public AsyncHandler() {
        String className = AsyncHandler.class.getName();
        Function<String, String> logManager = this.getPropertySupplier();
        String delegateClass = logManager.apply(className + ".delegate.class");
        if (delegateClass == null) {
            this.delegate = new StandardHandler();
        } else {
            try {
                this.delegate = AsyncHandler.class.getClassLoader().loadClass(delegateClass).asSubclass(Handler.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                this.reportError(e.getMessage(), e, 5);
                throw new IllegalStateException(e);
            }
        }
        this.queueSize = Optional.ofNullable(logManager.apply(className + ".queue.size")).map(Integer::parseInt).orElse(1024);
        this.queue = new ArrayBlockingQueue<LogRecord>(this.queueSize);
        Integer workerCount = Optional.ofNullable(logManager.apply(className + ".worker.count")).map(Integer::parseInt).orElse(1);
        this.workers = (Worker[])IntStream.range(0, workerCount).mapToObj(i -> new Worker(i, this, this.running)).toArray(Worker[]::new);
    }

    @Override
    public void setFormatter(Formatter newFormatter) throws SecurityException {
        this.delegate.setFormatter(newFormatter);
    }

    @Override
    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        this.delegate.setEncoding(encoding);
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        this.delegate.setFilter(newFilter);
    }

    @Override
    public void setErrorManager(ErrorManager em) {
        this.delegate.setErrorManager(em);
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        this.delegate.setLevel(newLevel);
    }

    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            record.getSourceClassName();
            record.getSourceMethodName();
            if (!this.queue.offer(record)) {
                this.delegate.publish(record);
            }
        }
    }

    @Override
    public void flush() {
        this.doFlush(this.queueSize);
    }

    @Override
    public void close() throws SecurityException {
        this.running.set(false);
        Stream.of(this.workers).forEach(w -> {
            try {
                w.join(TimeUnit.MINUTES.toMillis(1L));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.doFlush(Integer.MAX_VALUE);
        this.delegate.close();
    }

    private void doFlush(int max) {
        LogRecord next;
        int remaining = max;
        while ((next = (LogRecord)this.queue.poll()) != null && remaining-- > 0) {
            this.delegate.publish(next);
        }
    }

    protected Function<String, String> getPropertySupplier() {
        return LogManager.getLogManager()::getProperty;
    }

    private static class Worker
    extends Thread {
        public Worker(int index, AsyncHandler root, AtomicBoolean running) {
            super(() -> {
                while (running.get()) {
                    try {
                        LogRecord next = root.queue.poll(250L, TimeUnit.MILLISECONDS);
                        if (next == null) continue;
                        root.delegate.publish(next);
                    }
                    catch (RuntimeException re) {
                        root.getErrorManager().error(re.getMessage(), re, 5);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }, AsyncHandler.class.getName() + "-" + (index + 1));
            this.setDaemon(true);
            this.start();
        }
    }
}

