/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.logging.jul.handler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LocalFileHandler
extends Handler {
    private final Clock clock;
    private long limit = 0L;
    private int bufferSize = -1;
    private Pattern filenameRegex;
    private Pattern archiveFilenameRegex;
    private String filenamePattern = "${application.base}/logs/logs.%s.%03d.log";
    private String archiveFormat = "gzip";
    private long dateCheckInterval;
    private long archiveExpiryDuration;
    private int maxArchives = -1;
    private int compressionLevel;
    private long purgeExpiryDuration;
    private File archiveDir;
    private volatile int currentIndex;
    private volatile long lastTimestamp;
    private volatile String date;
    private volatile PrintWriter writer;
    private volatile int written;
    private volatile File currentFile;
    private final ReadWriteLock writerLock = new ReentrantReadWriteLock();
    private final Lock backgroundTaskLock = new ReentrantLock();
    private volatile boolean closed;
    private boolean noRotation;
    private boolean overwrite;
    private boolean truncateIfExists;
    private String zeroDate;
    private Supplier<String> currentDate;

    public LocalFileHandler() {
        this(Clock.systemDefaultZone());
    }

    public LocalFileHandler(Clock clock) {
        this.clock = clock;
        this.configure();
    }

    private void configure() {
        int indexIdxEnd;
        DateTimeFormatter formatter;
        Object fileNameReg;
        String className = LocalFileHandler.class.getName();
        this.noRotation = this.getProperty(className + ".noRotation", Boolean::parseBoolean, () -> false);
        this.overwrite = this.getProperty(className + ".overwrite", Boolean::parseBoolean, () -> false);
        this.truncateIfExists = this.getProperty(className + ".truncateIfExists", Boolean::parseBoolean, () -> false);
        this.dateCheckInterval = this.noRotation ? -1L : this.getProperty(className + ".dateCheckInterval", Duration::parse, () -> Duration.ofSeconds(5L)).toMillis();
        this.filenamePattern = LocalFileHandler.replace(this.getProperty(className + ".filenamePattern", Function.identity(), () -> this.filenamePattern));
        this.limit = this.getProperty(className + ".limit", Long::parseLong, () -> 0xA00000L);
        int lastSep = Math.max(this.filenamePattern.lastIndexOf(47), this.filenamePattern.lastIndexOf(92));
        Object object = fileNameReg = lastSep >= 0 ? this.filenamePattern.substring(lastSep + 1) : this.filenamePattern;
        if (((String)fileNameReg).contains("%sHm")) {
            fileNameReg = ((String)fileNameReg).replace("%sHm", "\\d{4}\\-\\d{2}\\-\\d{2}-\\d{2}-\\d{2}");
            this.zeroDate = "0000-00-00-00-00";
            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm");
            this.currentDate = () -> LocalDateTime.ofInstant(this.clock.instant(), this.clock.getZone()).format(formatter);
        } else if (((String)fileNameReg).contains("%sH")) {
            fileNameReg = ((String)fileNameReg).replace("%sH", "\\d{4}\\-\\d{2}\\-\\d{2}-\\d{2}");
            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH");
            this.currentDate = () -> LocalDateTime.ofInstant(this.clock.instant(), this.clock.getZone()).format(formatter);
        } else {
            fileNameReg = ((String)fileNameReg).replace("%s", "\\d{4}\\-\\d{2}\\-\\d{2}");
            this.zeroDate = "0000-00-00";
            this.currentDate = () -> LocalDate.ofInstant(this.clock.instant(), this.clock.getZone()).toString();
        }
        int indexIdxStart = ((String)fileNameReg).indexOf(37);
        if (indexIdxStart >= 0 && (indexIdxEnd = ((String)fileNameReg).indexOf(100, indexIdxStart)) >= 0) {
            fileNameReg = ((String)fileNameReg).substring(0, indexIdxStart) + "\\d*" + ((String)fileNameReg).substring(indexIdxEnd + 1);
        }
        this.filenameRegex = Pattern.compile((String)fileNameReg);
        this.compressionLevel = this.getProperty(className + ".compressionLevel", Integer::parseInt, () -> -1);
        this.archiveExpiryDuration = this.getProperty(className + ".archiveOlderThan", v -> Duration.parse(v).toMillis(), () -> -1L);
        this.archiveDir = new File(LocalFileHandler.replace(this.getProperty(className + ".archiveDirectory", Function.identity(), () -> "${application.base}/logs/archives/")));
        this.archiveFormat = LocalFileHandler.replace(this.getProperty(className + ".archiveFormat", Function.identity(), () -> this.archiveFormat));
        this.archiveFilenameRegex = Pattern.compile((String)fileNameReg + "\\." + this.archiveFormat);
        this.purgeExpiryDuration = this.getProperty(className + ".purgeOlderThan", v -> Duration.parse(v).toMillis(), () -> -1L);
        this.maxArchives = this.getProperty(className + ".maxArchives", Integer::parseInt, () -> -1);
        try {
            this.bufferSize = this.getProperty(className + ".bufferSize", Integer::parseInt, () -> -1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.lastTimestamp = this.clock.instant().toEpochMilli();
        this.date = this.currentDate();
    }

    protected String currentDate() {
        return this.currentDate.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        block12: {
            if (!this.isLoggable(record)) {
                return;
            }
            long now = this.clock.instant().toEpochMilli();
            if (this.dateCheckInterval < 0L || now - this.lastTimestamp > this.dateCheckInterval) {
                this.lastTimestamp = now;
            }
            try {
                String result;
                this.writerLock.readLock().lock();
                this.rotateIfNeeded();
                try {
                    result = this.getFormatter().format(record);
                }
                catch (Exception e) {
                    this.reportError(null, e, 5);
                    this.writerLock.readLock().unlock();
                    return;
                }
                try {
                    if (this.writer != null) {
                        this.writer.write(result);
                        if (this.bufferSize < 0) {
                            this.writer.flush();
                        }
                        break block12;
                    }
                    this.reportError(this.getClass().getSimpleName() + " is closed or not yet initialized, unable to log [" + result + "]", null, 1);
                }
                catch (Exception e) {
                    this.reportError(null, e, 1);
                }
            }
            finally {
                this.writerLock.readLock().unlock();
            }
        }
    }

    private void rotateIfNeeded() {
        if (!this.closed && this.writer == null) {
            try {
                this.writerLock.readLock().unlock();
                this.writerLock.writeLock().lock();
                if (!this.closed && this.writer == null) {
                    this.openWriter();
                }
            }
            finally {
                this.writerLock.writeLock().unlock();
                this.writerLock.readLock().lock();
            }
            return;
        }
        String currentDate = this.currentDate();
        if (!this.noRotation && this.shouldRotate(currentDate)) {
            try {
                this.writerLock.readLock().unlock();
                this.writerLock.writeLock().lock();
                if (this.shouldRotate(currentDate)) {
                    this.close();
                    if (currentDate != null && !this.date.equals(currentDate)) {
                        this.currentIndex = 0;
                        this.date = currentDate;
                    }
                    this.openWriter();
                }
            }
            finally {
                this.writerLock.writeLock().unlock();
                this.writerLock.readLock().lock();
            }
        }
    }

    private boolean shouldRotate(String currentDate) {
        return currentDate != null && !this.date.equals(currentDate) || this.limit > 0L && (long)this.written >= this.limit;
    }

    @Override
    public void close() {
        this.closed = true;
        this.writerLock.writeLock().lock();
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.write(this.getFormatter().getTail(this));
            this.writer.flush();
            this.writer.close();
            this.currentFile = null;
            this.writer = null;
        }
        catch (Exception e) {
            this.reportError(null, e, 3);
        }
        finally {
            this.writerLock.writeLock().unlock();
        }
        this.backgroundTaskLock.lock();
        this.backgroundTaskLock.unlock();
    }

    @Override
    public void flush() {
        this.writerLock.readLock().lock();
        try {
            this.writer.flush();
        }
        catch (Exception e) {
            this.reportError(null, e, 2);
        }
        finally {
            this.writerLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void openWriter() {
        Instant now = this.clock.instant();
        long beforeRotation = now.toEpochMilli();
        this.writerLock.writeLock().lock();
        OutputStream fos = null;
        try {
            File pathname;
            do {
                File parent;
                if (!(parent = (pathname = new File(this.formatFilename(this.filenamePattern, this.date, this.currentIndex))).getParentFile()).isDirectory() && !parent.mkdirs()) {
                    this.reportError("Unable to create [" + parent + "]", null, 4);
                    this.writer = null;
                    this.currentFile = null;
                    return;
                }
                ++this.currentIndex;
            } while (!this.overwrite && pathname.isFile());
            fos = new FileOutputStream(pathname, !this.truncateIfExists);
            CountingStream os = new CountingStream(this.bufferSize > 0 ? new BufferedOutputStream(fos, this.bufferSize) : fos);
            String encoding = this.getEncoding();
            OutputStreamWriter streamWriter = encoding != null ? new OutputStreamWriter((OutputStream)os, encoding) : new OutputStreamWriter(os);
            this.writer = new PrintWriter((Writer)streamWriter, false);
            this.writer.write(this.getFormatter().getHead(this));
            this.currentFile = pathname;
        }
        catch (Exception e) {
            this.reportError(null, e, 4);
            this.writer = null;
            this.currentFile = null;
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.writerLock.writeLock().unlock();
        }
        this.backgroundTaskLock.lock();
        try {
            this.evict(beforeRotation);
        }
        catch (Exception e) {
            this.reportError("Can't do the log eviction", e, 0);
        }
        finally {
            this.backgroundTaskLock.unlock();
        }
    }

    private void evict(long now) {
        if (this.purgeExpiryDuration > 0L) {
            this.purgeArchives(now);
        }
        if (this.archiveExpiryDuration > 0L) {
            this.archiveIfNeeded(now);
        }
        if (this.maxArchives > 0) {
            this.deleteUndesiredArchives();
        }
    }

    private void purgeArchives(long now) {
        File[] archives = this.listArchives();
        if (archives != null) {
            for (File archive : archives) {
                try {
                    BasicFileAttributes attr = Files.readAttributes(archive.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    if (now - attr.creationTime().toMillis() <= this.purgeExpiryDuration || Files.deleteIfExists(archive.toPath())) continue;
                    this.reportError("Can't delete " + archive.getAbsolutePath() + ".", null, 0);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private void archiveIfNeeded(long now) {
        File[] logs = new File(this.formatFilename(this.filenamePattern, this.zeroDate, 0)).getParentFile().listFiles((dir, name) -> this.filenameRegex.matcher(name).matches());
        if (logs != null) {
            for (File file : logs) {
                try {
                    BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    if (file.equals(this.currentFile) || !this.shouldArchive(now, attr)) continue;
                    this.createArchive(file);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private void deleteUndesiredArchives() {
        int toDelete;
        File[] archives = this.listArchives();
        if (archives != null && (toDelete = archives.length - this.maxArchives) > 0) {
            File[] sorted = (File[])Stream.of(archives).sorted((a, b) -> {
                try {
                    return Files.readAttributes(a.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().compareTo(Files.readAttributes(b.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime());
                }
                catch (IOException ie) {
                    this.getErrorManager().error(ie.getMessage(), ie, 0);
                    return a.getName().compareTo(b.getName());
                }
            }).toArray(File[]::new);
            Stream.of(sorted).limit(toDelete).forEach(File::delete);
        }
    }

    private boolean shouldArchive(long now, BasicFileAttributes attr) {
        return attr.creationTime().toMillis() < now && now - attr.lastModifiedTime().toMillis() > this.archiveExpiryDuration;
    }

    private File[] listArchives() {
        return this.archiveDir.listFiles((dir, name) -> this.archiveFilenameRegex.matcher(name).matches());
    }

    private String formatFilename(String pattern, String date, int index) {
        return String.format(pattern, date, index);
    }

    private void createArchive(File source) {
        block22: {
            FilterOutputStream outputStream;
            File target = new File(this.archiveDir, source.getName() + "." + this.archiveFormat);
            if (target.isFile()) {
                return;
            }
            File parentFile = target.getParentFile();
            if (!parentFile.isDirectory() && !parentFile.mkdirs()) {
                throw new IllegalStateException("Can't create " + parentFile.getAbsolutePath());
            }
            if (this.archiveFormat.equalsIgnoreCase("gzip")) {
                try {
                    outputStream = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(target)));
                    try {
                        Files.copy(source.toPath(), outputStream);
                        break block22;
                    }
                    finally {
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            try {
                outputStream = new ZipOutputStream(new FileOutputStream(target));
                try {
                    ((ZipOutputStream)outputStream).setLevel(this.compressionLevel);
                    try {
                        ZipEntry zipEntry = new ZipEntry(source.getName());
                        ((ZipOutputStream)outputStream).putNextEntry(zipEntry);
                        Files.copy(source.toPath(), outputStream);
                        ((ZipOutputStream)outputStream).closeEntry();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                finally {
                    ((ZipOutputStream)outputStream).close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            if (!Files.deleteIfExists(source.toPath())) {
                this.reportError("Can't delete " + source.getAbsolutePath() + ".", null, 0);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected <T> T getProperty(String name, Function<String, T> mapper, Supplier<T> defaultValue) {
        String value = LogManager.getLogManager().getProperty(name);
        if (value == null) {
            return defaultValue.get();
        }
        return mapper.apply(value);
    }

    protected static String replace(String str) {
        String result = str;
        int start = str.indexOf("${");
        if (start >= 0) {
            StringBuilder builder = new StringBuilder();
            int end = -1;
            while (start >= 0) {
                String replacement;
                builder.append(str, end + 1, start);
                end = str.indexOf(125, start + 2);
                if (end < 0) {
                    end = start - 1;
                    break;
                }
                String propName = str.substring(start + 2, end);
                String string = replacement = !propName.isEmpty() ? LocalFileHandler.readValue(propName) : null;
                if (replacement == null) {
                    replacement = System.getenv(propName);
                }
                if (replacement != null) {
                    builder.append(replacement);
                } else {
                    builder.append(str, start, end + 1);
                }
                start = str.indexOf("${", end + 1);
            }
            builder.append(str, end + 1, str.length());
            result = builder.toString();
        }
        return result;
    }

    private static String readValue(String propName) {
        if (propName.startsWith("env.")) {
            return System.getenv(propName.substring("env.".length()));
        }
        return System.getProperty(propName);
    }

    private final class CountingStream
    extends OutputStream {
        private final OutputStream out;

        private CountingStream(OutputStream out) {
            this.out = out;
            LocalFileHandler.this.written = 0;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++LocalFileHandler.this.written;
        }

        @Override
        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            LocalFileHandler.this.written += buff.length;
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            LocalFileHandler.this.written += len;
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

