/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.logging.jul.handler;

import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class StandardHandler
extends Handler {
    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            this.publish(record, this.getStream(record));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.flush();
    }

    protected PrintStream getStream(LogRecord record) {
        return record.getLevel().intValue() > Level.INFO.intValue() ? System.err : System.out;
    }

    private void publish(LogRecord record, PrintStream out) {
        try {
            out.write(this.getFormatter().format(record).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

