/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.logging.jul.logger;

import io.yupiik.logging.jul.YupiikLoggerFactory;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class YupiikLogger
extends Logger {
    private static final boolean GRAAL = YupiikLogger.isGraal();
    private volatile Logger delegate;
    private final ResourceBundle bundle;

    private static boolean isGraal() {
        if (System.getProperty("org.graalvm.nativeimage.imagecode") != null) {
            return true;
        }
        try {
            Class<?> imageInfo = Class.forName("org.graalvm.nativeimage.ImageInfo");
            return Boolean.TRUE.equals(imageInfo.getMethod("inImageCode", new Class[0]).invoke(null, new Object[0]));
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            return false;
        }
    }

    public YupiikLogger(String name, String resourceBundleName, ResourceBundle bundle) {
        super(name, bundle == null ? resourceBundleName : null);
        this.bundle = bundle == null ? super.getResourceBundle() : bundle;
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Logger getDelegate() {
        if (this.delegate == null) {
            YupiikLogger yupiikLogger = this;
            synchronized (yupiikLogger) {
                if (this.delegate == null) {
                    this.delegate = GRAAL ? YupiikLoggerFactory.get().getLogger(super.getName(), super.getResourceBundleName()) : this;
                }
            }
        }
        return this.delegate;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    @Override
    public void log(LogRecord record) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.log(record);
            return;
        }
        delegate.log(record);
    }

    @Override
    public void log(Level level, String msg) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.log(level, msg);
            return;
        }
        delegate.log(level, msg);
    }

    @Override
    public void log(Level level, Supplier<String> msgSupplier) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.log(level, msgSupplier);
            return;
        }
        delegate.log(level, msgSupplier);
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.log(level, msg, param1);
            return;
        }
        delegate.log(level, msg, param1);
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.log(level, msg, params);
            return;
        }
        delegate.log(level, msg, params);
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.log(level, msg, thrown);
            return;
        }
        delegate.log(level, msg, thrown);
    }

    @Override
    public void log(Level level, Throwable thrown, Supplier<String> msgSupplier) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.log(level, thrown, msgSupplier);
            return;
        }
        delegate.log(level, thrown, msgSupplier);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.logp(level, sourceClass, sourceMethod, msg);
            return;
        }
        delegate.logp(level, sourceClass, sourceMethod, msg);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, Supplier<String> msgSupplier) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.logp(level, sourceClass, sourceMethod, msgSupplier);
            return;
        }
        delegate.logp(level, sourceClass, sourceMethod, msgSupplier);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.logp(level, sourceClass, sourceMethod, msg, param1);
            return;
        }
        delegate.logp(level, sourceClass, sourceMethod, msg, param1);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.logp(level, sourceClass, sourceMethod, msg, params);
            return;
        }
        delegate.logp(level, sourceClass, sourceMethod, msg, params);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.logp(level, sourceClass, sourceMethod, msg, thrown);
            return;
        }
        delegate.logp(level, sourceClass, sourceMethod, msg, thrown);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, Throwable thrown, Supplier<String> msgSupplier) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.logp(level, sourceClass, sourceMethod, thrown, msgSupplier);
            return;
        }
        delegate.logp(level, sourceClass, sourceMethod, thrown, msgSupplier);
    }

    @Override
    @Deprecated
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.logrb(level, sourceClass, sourceMethod, bundleName, msg);
            return;
        }
        delegate.logrb(level, sourceClass, sourceMethod, bundleName, msg);
    }

    @Override
    @Deprecated
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.logrb(level, sourceClass, sourceMethod, bundleName, msg, param1);
            return;
        }
        delegate.logrb(level, sourceClass, sourceMethod, bundleName, msg, param1);
    }

    @Override
    @Deprecated
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.logrb(level, sourceClass, sourceMethod, bundleName, msg, params);
            return;
        }
        delegate.logrb(level, sourceClass, sourceMethod, bundleName, msg, params);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, ResourceBundle bundle, String msg, Object ... params) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.logrb(level, sourceClass, sourceMethod, bundle, msg, params);
            return;
        }
        delegate.logrb(level, sourceClass, sourceMethod, bundle, msg, params);
    }

    @Override
    public void logrb(Level level, ResourceBundle bundle, String msg, Object ... params) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.logrb(level, bundle, msg, params);
            return;
        }
        delegate.logrb(level, bundle, msg, params);
    }

    @Override
    @Deprecated
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.logrb(level, sourceClass, sourceMethod, bundleName, msg, thrown);
            return;
        }
        delegate.logrb(level, sourceClass, sourceMethod, bundleName, msg, thrown);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, ResourceBundle bundle, String msg, Throwable thrown) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.logrb(level, sourceClass, sourceMethod, bundle, msg, thrown);
            return;
        }
        delegate.logrb(level, sourceClass, sourceMethod, bundle, msg, thrown);
    }

    @Override
    public void logrb(Level level, ResourceBundle bundle, String msg, Throwable thrown) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.logrb(level, bundle, msg, thrown);
            return;
        }
        delegate.logrb(level, bundle, msg, thrown);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.entering(sourceClass, sourceMethod);
            return;
        }
        delegate.entering(sourceClass, sourceMethod);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.entering(sourceClass, sourceMethod, param1);
            return;
        }
        delegate.entering(sourceClass, sourceMethod, param1);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.entering(sourceClass, sourceMethod, params);
            return;
        }
        delegate.entering(sourceClass, sourceMethod, params);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.exiting(sourceClass, sourceMethod);
            return;
        }
        delegate.exiting(sourceClass, sourceMethod);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.exiting(sourceClass, sourceMethod, result);
            return;
        }
        delegate.exiting(sourceClass, sourceMethod, result);
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.throwing(sourceClass, sourceMethod, thrown);
            return;
        }
        delegate.throwing(sourceClass, sourceMethod, thrown);
    }

    @Override
    public void severe(String msg) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.severe(msg);
            return;
        }
        delegate.severe(msg);
    }

    @Override
    public void warning(String msg) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.warning(msg);
            return;
        }
        delegate.warning(msg);
    }

    @Override
    public void info(String msg) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.info(msg);
            return;
        }
        delegate.info(msg);
    }

    @Override
    public void config(String msg) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.config(msg);
            return;
        }
        delegate.config(msg);
    }

    @Override
    public void fine(String msg) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.fine(msg);
            return;
        }
        delegate.fine(msg);
    }

    @Override
    public void finer(String msg) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.finer(msg);
            return;
        }
        delegate.finer(msg);
    }

    @Override
    public void finest(String msg) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.finest(msg);
            return;
        }
        delegate.finest(msg);
    }

    @Override
    public void severe(Supplier<String> msgSupplier) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.severe(msgSupplier);
            return;
        }
        delegate.severe(msgSupplier);
    }

    @Override
    public void warning(Supplier<String> msgSupplier) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.warning(msgSupplier);
            return;
        }
        delegate.warning(msgSupplier);
    }

    @Override
    public void info(Supplier<String> msgSupplier) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.info(msgSupplier);
            return;
        }
        delegate.info(msgSupplier);
    }

    @Override
    public void config(Supplier<String> msgSupplier) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.config(msgSupplier);
            return;
        }
        delegate.config(msgSupplier);
    }

    @Override
    public void fine(Supplier<String> msgSupplier) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.fine(msgSupplier);
            return;
        }
        delegate.fine(msgSupplier);
    }

    @Override
    public void finer(Supplier<String> msgSupplier) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.finer(msgSupplier);
            return;
        }
        delegate.finer(msgSupplier);
    }

    @Override
    public void finest(Supplier<String> msgSupplier) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            super.finest(msgSupplier);
            return;
        }
        delegate.finest(msgSupplier);
    }

    @Override
    public boolean isLoggable(Level level) {
        Logger delegate = this.getDelegate();
        if (delegate == this) {
            return super.isLoggable(level);
        }
        return delegate.isLoggable(level);
    }
}

