/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import net.openhft.chronicle.bytes.BytesConsumer;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MultiReaderBytesRingBuffer;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.core.Jvm;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface BytesRingBuffer
extends BytesRingBufferStats,
BytesConsumer {
    public static final Logger LOG = LoggerFactory.getLogger(BytesRingBuffer.class);

    @NotNull
    public static BytesRingBuffer newInstance(@NotNull NativeBytesStore<Void> bytesStore) {
        return BytesRingBuffer.newInstance(bytesStore, 1);
    }

    @NotNull
    public static MultiReaderBytesRingBuffer newInstance(@NotNull NativeBytesStore<Void> bytesStore, int numReaders) {
        try {
            Class<MultiReaderBytesRingBuffer> aClass = BytesRingBuffer.clazz();
            Constructor<MultiReaderBytesRingBuffer> constructor = aClass.getDeclaredConstructor(BytesStore.class, Integer.TYPE);
            return constructor.newInstance(bytesStore, numReaders);
        }
        catch (Exception e) {
            LOG.error("This is a a commercial feature, please contact sales@higherfrequencytrading.com to unlock this feature.");
            throw Jvm.rethrow((Throwable)e);
        }
    }

    @NotNull
    public static Class<MultiReaderBytesRingBuffer> clazz() throws ClassNotFoundException {
        return Class.forName("software.chronicle.enterprise.queue.EnterpriseRingBuffer");
    }

    public static long sizeFor(long capacity) {
        return BytesRingBuffer.sizeFor(capacity, 1);
    }

    public static long sizeFor(long capacity, int numReaders) {
        try {
            Method sizeFor = BytesRingBuffer.clazz().getMethod("sizeFor", Long.TYPE, Integer.TYPE);
            return (Long)sizeFor.invoke(null, capacity, numReaders);
        }
        catch (Exception e) {
            LOG.error("This is a a commercial feature, please contact sales@higherfrequencytrading.com to unlock this feature.");
            throw Jvm.rethrow((Throwable)e);
        }
    }

    public void clear();

    public boolean offer(@NotNull BytesStore var1);

    @Override
    public boolean read(@NotNull BytesOut var1) throws BufferOverflowException;

    public long readRemaining();

    public boolean isEmpty();
}

