/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql.CFPropDefs;
import org.apache.cassandra.cql.Term;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CreateColumnFamilyStatement {
    private final String name;
    private final Map<Term, String> columns = new HashMap<Term, String>();
    private final List<String> keyValidator = new ArrayList<String>();
    private ByteBuffer keyAlias = null;
    private final CFPropDefs cfProps = new CFPropDefs();

    public CreateColumnFamilyStatement(String name) {
        this.name = name;
    }

    private void validate(List<ByteBuffer> variables) throws InvalidRequestException {
        AbstractType<?> comparator;
        this.cfProps.validate();
        if (this.keyValidator.size() < 1) {
            throw new InvalidRequestException("You must specify a PRIMARY KEY");
        }
        if (this.keyValidator.size() > 1) {
            throw new InvalidRequestException("You may only specify one PRIMARY KEY");
        }
        try {
            comparator = this.cfProps.getComparator();
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.toString());
        }
        catch (SyntaxException e) {
            throw new InvalidRequestException(e.toString());
        }
        for (Map.Entry<Term, String> column : this.columns.entrySet()) {
            ByteBuffer name = column.getKey().getByteBuffer(comparator, variables);
            if (this.keyAlias == null || !this.keyAlias.equals(name)) continue;
            throw new InvalidRequestException("Invalid column name: " + column.getKey().getText() + ", because it equals to the key_alias.");
        }
    }

    public void addColumn(Term term, String comparator) {
        this.columns.put(term, comparator);
    }

    public void setKeyType(String validator) {
        this.keyValidator.add(validator);
    }

    public String getKeyType() {
        return this.keyValidator.get(0);
    }

    public void setKeyAlias(String alias) {
        if (!alias.toUpperCase().equals("KEY")) {
            this.keyAlias = ByteBufferUtil.bytes(alias);
        }
    }

    public void addProperty(String name, String value) {
        this.cfProps.addProperty(name, value);
    }

    public String getName() {
        return this.name;
    }

    private Map<ByteBuffer, ColumnDefinition> getColumns(AbstractType<?> comparator) throws InvalidRequestException {
        HashMap<ByteBuffer, ColumnDefinition> columnDefs = new HashMap<ByteBuffer, ColumnDefinition>();
        for (Map.Entry<Term, String> col : this.columns.entrySet()) {
            InvalidRequestException ex;
            try {
                ByteBuffer columnName = comparator.fromString(col.getKey().getText());
                String validatorClassName = CFPropDefs.comparators.containsKey(col.getValue()) ? CFPropDefs.comparators.get(col.getValue()) : col.getValue();
                AbstractType<?> validator = TypeParser.parse(validatorClassName);
                columnDefs.put(columnName, new ColumnDefinition(columnName, validator, null, null, null, null));
            }
            catch (ConfigurationException e) {
                ex = new InvalidRequestException(e.toString());
                ex.initCause(e);
                throw ex;
            }
            catch (SyntaxException e) {
                ex = new InvalidRequestException(e.toString());
                ex.initCause(e);
                throw ex;
            }
        }
        return columnDefs;
    }

    public CFMetaData getCFMetaData(String keyspace, List<ByteBuffer> variables) throws InvalidRequestException {
        CFMetaData newCFMD;
        this.validate(variables);
        try {
            AbstractType<?> comparator = this.cfProps.getComparator();
            newCFMD = new CFMetaData(keyspace, this.name, ColumnFamilyType.Standard, comparator, null);
            if (CFMetaData.DEFAULT_COMPRESSOR != null && this.cfProps.compressionParameters.isEmpty()) {
                this.cfProps.compressionParameters.put("sstable_compression", CFMetaData.DEFAULT_COMPRESSOR);
            }
            newCFMD.comment(this.cfProps.getProperty("comment")).readRepairChance(this.getPropertyDouble("read_repair_chance", 0.1)).dcLocalReadRepairChance(this.getPropertyDouble("dclocal_read_repair_chance", 0.0)).replicateOnWrite(this.getPropertyBoolean("replicate_on_write", true)).gcGraceSeconds(this.getPropertyInt("gc_grace_seconds", 864000)).defaultValidator(this.cfProps.getValidator()).minCompactionThreshold(this.getPropertyInt("min_compaction_threshold", 4)).maxCompactionThreshold(this.getPropertyInt("max_compaction_threshold", 32)).columnMetadata(this.getColumns(comparator)).keyValidator(TypeParser.parse(CFPropDefs.comparators.get(this.getKeyType()))).compactionStrategyClass(this.cfProps.compactionStrategyClass).compactionStrategyOptions(this.cfProps.compactionStrategyOptions).compressionParameters(CompressionParameters.create(this.cfProps.compressionParameters)).caching(CFMetaData.Caching.fromString(this.getPropertyString("caching", CFMetaData.DEFAULT_CACHING_STRATEGY.toString()))).bloomFilterFpChance(this.getPropertyDouble("bloom_filter_fp_chance", null));
            if (this.keyAlias != null) {
                newCFMD.keyAliases(Collections.singletonList(this.keyAlias));
            }
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.toString());
        }
        catch (SyntaxException e) {
            throw new InvalidRequestException(e.toString());
        }
        return newCFMD;
    }

    private String getPropertyString(String key, String defaultValue) {
        return this.cfProps.getPropertyString(key, defaultValue);
    }

    private Boolean getPropertyBoolean(String key, Boolean defaultValue) throws InvalidRequestException {
        return this.cfProps.getPropertyBoolean(key, defaultValue);
    }

    private Double getPropertyDouble(String key, Double defaultValue) throws InvalidRequestException {
        return this.cfProps.getPropertyDouble(key, defaultValue);
    }

    private Integer getPropertyInt(String key, Integer defaultValue) throws InvalidRequestException {
        return this.cfProps.getPropertyInt(key, defaultValue);
    }

    public Map<Term, String> getColumns() {
        return this.columns;
    }
}

