/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql.jdbc.JdbcBoolean;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;

public class BooleanType
extends AbstractType<Boolean> {
    public static final BooleanType instance = new BooleanType();

    BooleanType() {
    }

    @Override
    public Boolean compose(ByteBuffer bytes) {
        return JdbcBoolean.instance.compose(bytes);
    }

    @Override
    public ByteBuffer decompose(Boolean value) {
        return JdbcBoolean.instance.decompose(value);
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1 == null || o1.remaining() != 1) {
            return o2 == null || o2.remaining() != 1 ? 0 : -1;
        }
        if (o2 == null || o2.remaining() != 1) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        try {
            return JdbcBoolean.instance.getString(bytes);
        }
        catch (org.apache.cassandra.cql.jdbc.MarshalException e) {
            throw new MarshalException(e.getMessage());
        }
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty() || source.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return this.decompose(false);
        }
        if (source.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return this.decompose(true);
        }
        throw new MarshalException(String.format("unable to make boolean from '%s'", source));
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 1 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("Expected 1 or 0 byte value (%d)", bytes.remaining()));
        }
    }
}

