/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.EmptyType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.utils.Pair;

public class SetType<T>
extends CollectionType<Set<T>> {
    private static final Map<AbstractType<?>, SetType> instances = new HashMap();
    public final AbstractType<T> elements;

    public static SetType<?> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> l = parser.getTypeParameters();
        if (l.size() != 1) {
            throw new ConfigurationException("SetType takes exactly 1 type parameter");
        }
        return SetType.getInstance(l.get(0));
    }

    public static synchronized <T> SetType<T> getInstance(AbstractType<T> elements) {
        SetType<T> t = instances.get(elements);
        if (t == null) {
            t = new SetType<T>(elements);
            instances.put(elements, t);
        }
        return t;
    }

    public SetType(AbstractType<T> elements) {
        super(CollectionType.Kind.SET);
        this.elements = elements;
    }

    @Override
    public AbstractType<T> nameComparator() {
        return this.elements;
    }

    @Override
    public AbstractType<?> valueComparator() {
        return EmptyType.instance;
    }

    @Override
    public Set<T> compose(ByteBuffer bytes) {
        try {
            ByteBuffer input = bytes.duplicate();
            int n = input.getShort();
            LinkedHashSet<T> l = new LinkedHashSet<T>(n);
            for (int i = 0; i < n; ++i) {
                short s = input.getShort();
                byte[] data = new byte[s];
                input.get(data);
                ByteBuffer databb = ByteBuffer.wrap(data);
                this.elements.validate(databb);
                l.add(this.elements.compose(databb));
            }
            return l;
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a set");
        }
    }

    @Override
    public ByteBuffer decompose(Set<T> value) {
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(value.size());
        int size = 0;
        for (T elt : value) {
            ByteBuffer bb = this.elements.decompose(elt);
            bbs.add(bb);
            size += 2 + bb.remaining();
        }
        return this.pack(bbs, value.size(), size);
    }

    @Override
    protected void appendToStringBuilder(StringBuilder sb) {
        sb.append(this.getClass().getName()).append(TypeParser.stringifyTypeParameters(Collections.singletonList(this.elements)));
    }

    @Override
    public ByteBuffer serialize(List<Pair<ByteBuffer, IColumn>> columns) {
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(columns.size());
        int size = 0;
        for (Pair<ByteBuffer, IColumn> p : columns) {
            bbs.add((ByteBuffer)p.left);
            size += 2 + ((ByteBuffer)p.left).remaining();
        }
        return this.pack(bbs, columns.size(), size);
    }
}

