/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentMap;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class StreamingMetrics {
    public static final String GROUP_NAME = "org.apache.cassandra.metrics";
    public static final String TYPE_NAME = "Streaming";
    private static final ConcurrentMap<InetAddress, StreamingMetrics> instances = new NonBlockingHashMap();
    public static final Counter activeStreamsOutbound = Metrics.newCounter((MetricName)new MetricName("org.apache.cassandra.metrics", "Streaming", "ActiveOutboundStreams"));
    public static final Counter totalIncomingBytes = Metrics.newCounter((MetricName)new MetricName("org.apache.cassandra.metrics", "Streaming", "TotalIncomingBytes"));
    public static final Counter totalOutgoingBytes = Metrics.newCounter((MetricName)new MetricName("org.apache.cassandra.metrics", "Streaming", "TotalOutgoingBytes"));
    public final Counter incomingBytes;
    public final Counter outgoingBytes;

    public static StreamingMetrics get(InetAddress ip) {
        StreamingMetrics metrics = (StreamingMetrics)instances.get(ip);
        if (metrics == null) {
            metrics = new StreamingMetrics(ip);
            instances.put(ip, metrics);
        }
        return metrics;
    }

    public StreamingMetrics(InetAddress peer) {
        this.incomingBytes = Metrics.newCounter((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "IncomingBytes", peer.getHostAddress()));
        this.outgoingBytes = Metrics.newCounter((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "OutgoingBytes", peer.getHostAddress()));
    }
}

