/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.utils.SimpleCondition;

public abstract class AbstractWriteResponseHandler
implements IAsyncCallback {
    private final SimpleCondition condition = new SimpleCondition();
    protected final long startTime;
    protected final Collection<InetAddress> naturalEndpoints;
    protected final ConsistencyLevel consistencyLevel;
    protected final Runnable callback;
    protected final Collection<InetAddress> pendingEndpoints;
    private final WriteType writeType;

    protected AbstractWriteResponseHandler(Collection<InetAddress> naturalEndpoints, Collection<InetAddress> pendingEndpoints, ConsistencyLevel consistencyLevel, Runnable callback, WriteType writeType) {
        this.pendingEndpoints = pendingEndpoints;
        this.startTime = System.currentTimeMillis();
        this.consistencyLevel = consistencyLevel;
        this.naturalEndpoints = naturalEndpoints;
        this.callback = callback;
        this.writeType = writeType;
    }

    public void get() throws WriteTimeoutException {
        boolean success;
        long timeout = DatabaseDescriptor.getWriteRpcTimeout() - (System.currentTimeMillis() - this.startTime);
        try {
            success = this.condition.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        if (!success) {
            throw new WriteTimeoutException(this.writeType, this.consistencyLevel, this.ackCount(), this.blockFor());
        }
    }

    protected abstract int ackCount();

    protected int blockFor() {
        return this.blockForCL() + this.pendingEndpoints.size();
    }

    protected abstract int blockForCL();

    public abstract void response(MessageIn var1);

    public abstract void assureSufficientLiveNodes() throws UnavailableException;

    protected void signal() {
        this.condition.signal();
        if (this.callback != null) {
            this.callback.run();
        }
    }
}

