/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.util.Collection;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.utils.FBUtilities;

public class DatacenterWriteResponseHandler
extends WriteResponseHandler {
    private static final IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
    private static final String localdc = snitch.getDatacenter(FBUtilities.getBroadcastAddress());

    public DatacenterWriteResponseHandler(Collection<InetAddress> naturalEndpoints, Collection<InetAddress> pendingEndpoints, ConsistencyLevel consistencyLevel, String table, Runnable callback, WriteType writeType) {
        super(naturalEndpoints, pendingEndpoints, consistencyLevel, table, callback, writeType);
        assert (consistencyLevel == ConsistencyLevel.LOCAL_QUORUM);
    }

    @Override
    public void response(MessageIn message) {
        if ((message == null || localdc.equals(snitch.getDatacenter(message.from))) && this.responses.decrementAndGet() == 0) {
            this.signal();
        }
    }

    @Override
    public void assureSufficientLiveNodes() throws UnavailableException {
        int liveNodes = 0;
        for (InetAddress destination : Iterables.concat((Iterable)this.naturalEndpoints, (Iterable)this.pendingEndpoints)) {
            if (!localdc.equals(snitch.getDatacenter(destination)) || !FailureDetector.instance.isAlive(destination)) continue;
            ++liveNodes;
        }
        if (liveNodes < this.responses.get()) {
            throw new UnavailableException(this.consistencyLevel, this.responses.get(), liveNodes);
        }
    }
}

