/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.thrift.CqlPreparedResult;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlResultType;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.utils.MD5Digest;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public abstract class ResultMessage
extends Message.Response {
    public static final Message.Codec<ResultMessage> codec = new Message.Codec<ResultMessage>(){

        @Override
        public ResultMessage decode(ChannelBuffer body) {
            Kind kind = Kind.fromId(body.readInt());
            return (ResultMessage)kind.subcodec.decode(body);
        }

        @Override
        public ChannelBuffer encode(ResultMessage msg) {
            ChannelBuffer kcb = ChannelBuffers.buffer((int)4);
            kcb.writeInt(msg.kind.id);
            ChannelBuffer body = msg.encodeBody();
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{kcb, body});
        }
    };
    public final Kind kind;

    protected ResultMessage(Kind kind) {
        super(Message.Type.RESULT);
        this.kind = kind;
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this);
    }

    protected abstract ChannelBuffer encodeBody();

    public abstract CqlResult toThriftResult();

    public static class SchemaChange
    extends ResultMessage {
        public final Change change;
        public final String keyspace;
        public final String columnFamily;
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ChannelBuffer body) {
                String cStr = CBUtil.readString(body);
                Change change = null;
                try {
                    change = Enum.valueOf(Change.class, cStr.toUpperCase());
                }
                catch (IllegalStateException e) {
                    throw new ProtocolException("Unknown Schema change action: " + cStr);
                }
                String keyspace = CBUtil.readString(body);
                String columnFamily = CBUtil.readString(body);
                return new SchemaChange(change, keyspace, columnFamily);
            }

            @Override
            public ChannelBuffer encode(ResultMessage msg) {
                assert (msg instanceof SchemaChange);
                SchemaChange scm = (SchemaChange)msg;
                ChannelBuffer a = CBUtil.stringToCB(scm.change.toString());
                ChannelBuffer k = CBUtil.stringToCB(scm.keyspace);
                ChannelBuffer c = CBUtil.stringToCB(scm.columnFamily);
                return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{a, k, c});
            }
        };

        public SchemaChange(Change change, String keyspace) {
            this(change, keyspace, "");
        }

        public SchemaChange(Change change, String keyspace, String columnFamily) {
            super(Kind.SCHEMA_CHANGE);
            this.change = change;
            this.keyspace = keyspace;
            this.columnFamily = columnFamily;
        }

        @Override
        protected ChannelBuffer encodeBody() {
            return subcodec.encode(this);
        }

        @Override
        public CqlResult toThriftResult() {
            return new CqlResult(CqlResultType.VOID);
        }

        public String toString() {
            return "RESULT schema change " + (Object)((Object)this.change) + " on " + this.keyspace + (this.columnFamily.isEmpty() ? "" : "." + this.columnFamily);
        }

        public static enum Change {
            CREATED,
            UPDATED,
            DROPPED;

        }
    }

    public static class Prepared
    extends ResultMessage {
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ChannelBuffer body) {
                MD5Digest id = MD5Digest.wrap(CBUtil.readBytes(body));
                return new Prepared(id, -1, ResultSet.Metadata.codec.decode(body));
            }

            @Override
            public ChannelBuffer encode(ResultMessage msg) {
                assert (msg instanceof Prepared);
                Prepared prepared = (Prepared)msg;
                assert (prepared.statementId != null);
                return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{CBUtil.bytesToCB(prepared.statementId.bytes), ResultSet.Metadata.codec.encode(prepared.metadata)});
            }
        };
        public final MD5Digest statementId;
        public final ResultSet.Metadata metadata;
        private final int thriftStatementId;

        public Prepared(MD5Digest statementId, List<ColumnSpecification> names) {
            this(statementId, -1, new ResultSet.Metadata(names));
        }

        public static Prepared forThrift(int statementId, List<ColumnSpecification> names) {
            return new Prepared(null, statementId, new ResultSet.Metadata(names));
        }

        private Prepared(MD5Digest statementId, int thriftStatementId, ResultSet.Metadata metadata) {
            super(Kind.PREPARED);
            this.statementId = statementId;
            this.thriftStatementId = thriftStatementId;
            this.metadata = metadata;
        }

        @Override
        protected ChannelBuffer encodeBody() {
            return subcodec.encode(this);
        }

        @Override
        public CqlResult toThriftResult() {
            throw new UnsupportedOperationException();
        }

        public CqlPreparedResult toThriftPreparedResult() {
            ArrayList<String> namesString = new ArrayList<String>(this.metadata.names.size());
            ArrayList<String> typesString = new ArrayList<String>(this.metadata.names.size());
            for (ColumnSpecification name : this.metadata.names) {
                namesString.add(name.toString());
                typesString.add(TypeParser.getShortName(name.type));
            }
            return new CqlPreparedResult(this.thriftStatementId, this.metadata.names.size()).setVariable_types(typesString).setVariable_names(namesString);
        }

        public String toString() {
            return "RESULT PREPARED " + this.statementId + " " + this.metadata;
        }
    }

    public static class Rows
    extends ResultMessage {
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ChannelBuffer body) {
                return new Rows(ResultSet.codec.decode(body));
            }

            @Override
            public ChannelBuffer encode(ResultMessage msg) {
                assert (msg instanceof Rows);
                Rows rowMsg = (Rows)msg;
                return ResultSet.codec.encode(rowMsg.result);
            }
        };
        public final ResultSet result;

        public Rows(ResultSet result) {
            super(Kind.ROWS);
            this.result = result;
        }

        @Override
        protected ChannelBuffer encodeBody() {
            return subcodec.encode(this);
        }

        @Override
        public CqlResult toThriftResult() {
            return this.result.toThriftResult();
        }

        public String toString() {
            return "ROWS " + this.result;
        }
    }

    public static class SetKeyspace
    extends ResultMessage {
        public final String keyspace;
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ChannelBuffer body) {
                String keyspace = CBUtil.readString(body);
                return new SetKeyspace(keyspace);
            }

            @Override
            public ChannelBuffer encode(ResultMessage msg) {
                assert (msg instanceof SetKeyspace);
                return CBUtil.stringToCB(((SetKeyspace)msg).keyspace);
            }
        };

        public SetKeyspace(String keyspace) {
            super(Kind.SET_KEYSPACE);
            this.keyspace = keyspace;
        }

        @Override
        protected ChannelBuffer encodeBody() {
            return subcodec.encode(this);
        }

        @Override
        public CqlResult toThriftResult() {
            return new CqlResult(CqlResultType.VOID);
        }

        public String toString() {
            return "RESULT set keyspace " + this.keyspace;
        }
    }

    public static class Void
    extends ResultMessage {
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ChannelBuffer body) {
                return new Void();
            }

            @Override
            public ChannelBuffer encode(ResultMessage msg) {
                assert (msg instanceof Void);
                return ChannelBuffers.EMPTY_BUFFER;
            }
        };

        public Void() {
            super(Kind.VOID);
        }

        @Override
        protected ChannelBuffer encodeBody() {
            return subcodec.encode(this);
        }

        @Override
        public CqlResult toThriftResult() {
            return new CqlResult(CqlResultType.VOID);
        }

        public String toString() {
            return "EMPTY RESULT";
        }
    }

    public static enum Kind {
        VOID(1, Void.subcodec),
        ROWS(2, Rows.subcodec),
        SET_KEYSPACE(3, SetKeyspace.subcodec),
        PREPARED(4, Prepared.subcodec),
        SCHEMA_CHANGE(5, SchemaChange.subcodec);

        public final int id;
        public final Message.Codec<ResultMessage> subcodec;
        private static final Kind[] ids;

        private Kind(int id, Message.Codec<ResultMessage> subcodec) {
            this.id = id;
            this.subcodec = subcodec;
        }

        public static Kind fromId(int id) {
            Kind k = ids[id];
            if (k == null) {
                throw new ProtocolException(String.format("Unknown kind id %d in RESULT message", id));
            }
            return k;
        }

        static {
            int maxId = -1;
            for (Kind k : Kind.values()) {
                maxId = Math.max(maxId, k.id);
            }
            ids = new Kind[maxId + 1];
            for (Kind k : Kind.values()) {
                if (ids[k.id] != null) {
                    throw new IllegalStateException("Duplicate kind id");
                }
                Kind.ids[k.id] = k;
            }
        }
    }
}

