/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.join;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapred.join.CompositeInputFormat;
import org.apache.hadoop.mapred.join.IncomparableKey;
import org.apache.hadoop.mapred.join.TestDatamerge;
import org.apache.hadoop.mapred.join.TupleWritable;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDatamerge
extends TestCase {
    private static MiniDFSCluster cluster = null;

    public static Test suite() {
        1 setup = new /* Unavailable Anonymous Inner Class!! */;
        return setup;
    }

    private static SequenceFile.Writer[] createWriters(Path testdir, Configuration conf, int srcs, Path[] src) throws IOException {
        for (int i = 0; i < srcs; ++i) {
            src[i] = new Path(testdir, Integer.toString(i + 10, 36));
        }
        SequenceFile.Writer[] out = new SequenceFile.Writer[srcs];
        for (int i = 0; i < srcs; ++i) {
            out[i] = new SequenceFile.Writer(testdir.getFileSystem(conf), conf, src[i], IntWritable.class, IntWritable.class);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path[] writeSimpleSrc(Path testdir, Configuration conf, int srcs) throws IOException {
        SequenceFile.Writer[] out = null;
        Path[] src = new Path[srcs];
        try {
            out = TestDatamerge.createWriters((Path)testdir, (Configuration)conf, (int)srcs, (Path[])src);
            int capacity = srcs * 2 + 1;
            IntWritable key = new IntWritable();
            IntWritable val = new IntWritable();
            for (int k = 0; k < capacity; ++k) {
                for (int i = 0; i < srcs; ++i) {
                    key.set(k % srcs == 0 ? k * srcs : k * srcs + i);
                    val.set(10 * k + i);
                    out[i].append((Writable)key, (Writable)val);
                    if (i != k) continue;
                    out[i].append((Writable)key, (Writable)val);
                }
            }
        }
        finally {
            if (out != null) {
                for (int i = 0; i < srcs; ++i) {
                    if (out[i] == null) continue;
                    out[i].close();
                }
            }
        }
        return src;
    }

    private static String stringify(IntWritable key, Writable val) {
        StringBuilder sb = new StringBuilder();
        sb.append("(" + key);
        sb.append("," + val + ")");
        return sb.toString();
    }

    private static void joinAs(String jointype, Class<? extends SimpleCheckerBase> c) throws Exception {
        int srcs = 4;
        Configuration conf = new Configuration();
        JobConf job = new JobConf(conf, c);
        Path base = cluster.getFileSystem().makeQualified(new Path("/" + jointype));
        Path[] src = TestDatamerge.writeSimpleSrc((Path)base, (Configuration)conf, (int)4);
        job.set("mapreduce.join.expr", CompositeInputFormat.compose((String)jointype, SequenceFileInputFormat.class, (Path[])src));
        job.setInt("testdatamerge.sources", 4);
        job.setInputFormat(CompositeInputFormat.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(base, "out"));
        job.setMapperClass(c);
        job.setReducerClass(c);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(IntWritable.class);
        JobClient.runJob((JobConf)job);
        base.getFileSystem((Configuration)job).delete(base, true);
    }

    public void testSimpleInnerJoin() throws Exception {
        TestDatamerge.joinAs((String)"inner", InnerJoinChecker.class);
    }

    public void testSimpleOuterJoin() throws Exception {
        TestDatamerge.joinAs((String)"outer", OuterJoinChecker.class);
    }

    public void testSimpleOverride() throws Exception {
        TestDatamerge.joinAs((String)"override", OverrideChecker.class);
    }

    public void testNestedJoin() throws Exception {
        int i;
        int SOURCES = 3;
        int ITEMS = 16;
        JobConf job = new JobConf();
        Path base = cluster.getFileSystem().makeQualified(new Path("/nested"));
        int[][] source = new int[3][];
        for (int i2 = 0; i2 < 3; ++i2) {
            source[i2] = new int[16];
            for (int j = 0; j < 16; ++j) {
                source[i2][j] = (i2 + 2) * (j + 1);
            }
        }
        Path[] src = new Path[3];
        SequenceFile.Writer[] out = TestDatamerge.createWriters((Path)base, (Configuration)job, (int)3, (Path[])src);
        IntWritable k = new IntWritable();
        for (int i3 = 0; i3 < 3; ++i3) {
            IntWritable v = new IntWritable();
            v.set(i3);
            for (int j = 0; j < 16; ++j) {
                k.set(source[i3][j]);
                out[i3].append((Writable)k, (Writable)v);
            }
            out[i3].close();
        }
        out = null;
        StringBuilder sb = new StringBuilder();
        sb.append("outer(inner(");
        for (i = 0; i < 3; ++i) {
            sb.append(CompositeInputFormat.compose(SequenceFileInputFormat.class, (String)src[i].toString()));
            if (i + 1 == 3) continue;
            sb.append(",");
        }
        sb.append("),outer(");
        sb.append(CompositeInputFormat.compose(Fake_IF.class, (String)"foobar"));
        sb.append(",");
        for (i = 0; i < 3; ++i) {
            sb.append(CompositeInputFormat.compose(SequenceFileInputFormat.class, (String)src[i].toString()));
            sb.append(",");
        }
        sb.append(CompositeInputFormat.compose(Fake_IF.class, (String)"raboof") + "))");
        job.set("mapreduce.join.expr", sb.toString());
        job.setInputFormat(CompositeInputFormat.class);
        Path outf = new Path(base, "out");
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outf);
        Fake_IF.setKeyClass((JobConf)job, IntWritable.class);
        Fake_IF.setValClass((JobConf)job, IntWritable.class);
        job.setMapperClass(IdentityMapper.class);
        job.setReducerClass(IdentityReducer.class);
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(TupleWritable.class);
        job.setOutputFormat(SequenceFileOutputFormat.class);
        JobClient.runJob((JobConf)job);
        FileStatus[] outlist = cluster.getFileSystem().listStatus(outf, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter());
        TestDatamerge.assertEquals((int)1, (int)outlist.length);
        TestDatamerge.assertTrue((0L < outlist[0].getLen() ? 1 : 0) != 0);
        SequenceFile.Reader r = new SequenceFile.Reader((FileSystem)cluster.getFileSystem(), outlist[0].getPath(), (Configuration)job);
        TupleWritable v = new TupleWritable();
        while (r.next((Writable)k, (Writable)v)) {
            int i4;
            TestDatamerge.assertFalse((boolean)((TupleWritable)v.get(1)).has(0));
            TestDatamerge.assertFalse((boolean)((TupleWritable)v.get(1)).has(4));
            boolean chk = true;
            int ki = k.get();
            for (i4 = 2; i4 < 5; ++i4) {
                if (ki % i4 == 0 && ki <= i4 * 16) {
                    TestDatamerge.assertEquals((int)(i4 - 2), (int)((IntWritable)((TupleWritable)v.get(1)).get(i4 - 1)).get());
                    continue;
                }
                chk = false;
            }
            if (chk) {
                TestDatamerge.assertTrue((boolean)v.has(0));
                for (i4 = 0; i4 < 3; ++i4) {
                    TestDatamerge.assertTrue((boolean)((TupleWritable)v.get(0)).has(i4));
                }
                continue;
            }
            TestDatamerge.assertFalse((boolean)v.has(0));
        }
        r.close();
        base.getFileSystem((Configuration)job).delete(base, true);
    }

    public void testEmptyJoin() throws Exception {
        JobConf job = new JobConf();
        Path base = cluster.getFileSystem().makeQualified(new Path("/empty"));
        Path[] src = new Path[]{new Path(base, "i0"), new Path("i1"), new Path("i2")};
        job.set("mapreduce.join.expr", CompositeInputFormat.compose((String)"outer", Fake_IF.class, (Path[])src));
        job.setInputFormat(CompositeInputFormat.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(base, "out"));
        job.setMapperClass(IdentityMapper.class);
        job.setReducerClass(IdentityReducer.class);
        job.setOutputKeyClass(IncomparableKey.class);
        job.setOutputValueClass(NullWritable.class);
        JobClient.runJob((JobConf)job);
        base.getFileSystem((Configuration)job).delete(base, true);
    }

    static /* synthetic */ MiniDFSCluster access$002(MiniDFSCluster x0) {
        cluster = x0;
        return cluster;
    }

    static /* synthetic */ MiniDFSCluster access$000() {
        return cluster;
    }

    static /* synthetic */ String access$200(IntWritable x0, Writable x1) {
        return TestDatamerge.stringify((IntWritable)x0, (Writable)x1);
    }
}

