/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.ClientBaseWithFixes;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRMFailover
extends ClientBaseWithFixes {
    private static final Log LOG = LogFactory.getLog((String)TestRMFailover.class.getName());
    private static final HAServiceProtocol.StateChangeRequestInfo req = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
    private static final String RM1_NODE_ID = "rm1";
    private static final int RM1_PORT_BASE = 10000;
    private static final String RM2_NODE_ID = "rm2";
    private static final int RM2_PORT_BASE = 20000;
    private Configuration conf;
    private MiniYARNCluster cluster;
    private ApplicationId fakeAppId;

    private void setConfForRM(String rmId, String prefix, String value) {
        this.conf.set(HAUtil.addSuffix((String)prefix, (String)rmId), value);
    }

    private void setRpcAddressForRM(String rmId, int base) {
        this.setConfForRM(rmId, "yarn.resourcemanager.address", "0.0.0.0:" + (base + 8032));
        this.setConfForRM(rmId, "yarn.resourcemanager.scheduler.address", "0.0.0.0:" + (base + 8030));
        this.setConfForRM(rmId, "yarn.resourcemanager.admin.address", "0.0.0.0:" + (base + 8033));
        this.setConfForRM(rmId, "yarn.resourcemanager.resource-tracker.address", "0.0.0.0:" + (base + 8031));
        this.setConfForRM(rmId, "yarn.resourcemanager.webapp.address", "0.0.0.0:" + (base + 8088));
        this.setConfForRM(rmId, "yarn.resourcemanager.webapp.https.address", "0.0.0.0:" + (base + 8090));
    }

    @Before
    public void setup() throws IOException {
        this.fakeAppId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)0);
        this.conf = new YarnConfiguration();
        this.conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        this.conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        this.setRpcAddressForRM(RM1_NODE_ID, 10000);
        this.setRpcAddressForRM(RM2_NODE_ID, 20000);
        this.conf.setLong("yarn.client.failover-sleep-base-ms", 100L);
        this.conf.setBoolean("yarn.minicluster.fixed.ports", true);
        this.conf.setBoolean("yarn.minicluster.use-rpc", true);
        this.cluster = new MiniYARNCluster(TestRMFailover.class.getName(), 2, 1, 1, 1);
    }

    @After
    public void teardown() {
        this.cluster.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyClientConnection() {
        int numRetries = 3;
        while (numRetries-- > 0) {
            YarnConfiguration conf = new YarnConfiguration(this.conf);
            YarnClient client = YarnClient.createYarnClient();
            client.init((Configuration)conf);
            client.start();
            try {
                client.getApplications();
                return;
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
            finally {
                client.stop();
            }
        }
        Assert.fail((String)"Client couldn't connect to the Active RM");
    }

    private void verifyConnections() throws InterruptedException, YarnException {
        Assert.assertTrue((String)"NMs failed to connect to the RM", (boolean)this.cluster.waitForNodeManagersToConnect(20000L));
        this.verifyClientConnection();
    }

    private AdminService getAdminService(int index) {
        return this.cluster.getResourceManager(index).getRMContext().getRMAdminService();
    }

    private void explicitFailover() throws IOException {
        int activeRMIndex = this.cluster.getActiveRMIndex();
        int newActiveRMIndex = (activeRMIndex + 1) % 2;
        this.getAdminService(activeRMIndex).transitionToStandby(req);
        this.getAdminService(newActiveRMIndex).transitionToActive(req);
        Assert.assertEquals((String)"Failover failed", (long)newActiveRMIndex, (long)this.cluster.getActiveRMIndex());
    }

    private void failover() throws IOException, InterruptedException, YarnException {
        int activeRMIndex = this.cluster.getActiveRMIndex();
        this.cluster.stopResourceManager(activeRMIndex);
        Assert.assertEquals((String)"Failover failed", (long)((activeRMIndex + 1) % 2), (long)this.cluster.getActiveRMIndex());
        this.cluster.restartResourceManager(activeRMIndex);
    }

    @Test
    public void testExplicitFailover() throws YarnException, InterruptedException, IOException {
        this.conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        this.cluster.init(this.conf);
        this.cluster.start();
        this.getAdminService(0).transitionToActive(req);
        Assert.assertFalse((String)"RM never turned active", (-1 == this.cluster.getActiveRMIndex() ? 1 : 0) != 0);
        this.verifyConnections();
        this.explicitFailover();
        this.verifyConnections();
        this.explicitFailover();
        this.verifyConnections();
    }

    @Test
    public void testAutomaticFailover() throws YarnException, InterruptedException, IOException {
        this.conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", true);
        this.conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.embedded", true);
        this.conf.set("yarn.resourcemanager.cluster-id", "yarn-test-cluster");
        this.conf.set("yarn.resourcemanager.zk-address", this.hostPort);
        this.conf.setInt("yarn.resourcemanager.zk-timeout-ms", 2000);
        this.cluster.init(this.conf);
        this.cluster.start();
        Assert.assertFalse((String)"RM never turned active", (-1 == this.cluster.getActiveRMIndex() ? 1 : 0) != 0);
        this.verifyConnections();
        this.failover();
        this.verifyConnections();
        this.failover();
        this.verifyConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebAppProxyInStandAloneMode() throws YarnException, InterruptedException, IOException {
        WebAppProxyServer webAppProxyServer = new WebAppProxyServer();
        try {
            this.conf.set("yarn.web-proxy.address", "0.0.0.0:9099");
            this.cluster.init(this.conf);
            this.cluster.start();
            this.getAdminService(0).transitionToActive(req);
            Assert.assertFalse((String)"RM never turned active", (-1 == this.cluster.getActiveRMIndex() ? 1 : 0) != 0);
            this.verifyConnections();
            webAppProxyServer.init(this.conf);
            Assert.assertEquals((Object)Service.STATE.INITED, (Object)webAppProxyServer.getServiceState());
            webAppProxyServer.start();
            Assert.assertEquals((Object)Service.STATE.STARTED, (Object)webAppProxyServer.getServiceState());
            URL wrongUrl = new URL("http://0.0.0.0:9099/proxy/" + this.fakeAppId);
            HttpURLConnection proxyConn = (HttpURLConnection)wrongUrl.openConnection();
            proxyConn.connect();
            this.verifyExpectedException(proxyConn.getResponseMessage());
            this.explicitFailover();
            this.verifyConnections();
            proxyConn.connect();
            this.verifyExpectedException(proxyConn.getResponseMessage());
        }
        finally {
            webAppProxyServer.stop();
        }
    }

    @Test
    public void testEmbeddedWebAppProxy() throws YarnException, InterruptedException, IOException {
        this.cluster.init(this.conf);
        this.cluster.start();
        this.getAdminService(0).transitionToActive(req);
        Assert.assertFalse((String)"RM never turned active", (-1 == this.cluster.getActiveRMIndex() ? 1 : 0) != 0);
        this.verifyConnections();
        URL wrongUrl = new URL("http://0.0.0.0:18088/proxy/" + this.fakeAppId);
        HttpURLConnection proxyConn = (HttpURLConnection)wrongUrl.openConnection();
        proxyConn.connect();
        this.verifyExpectedException(proxyConn.getResponseMessage());
        this.explicitFailover();
        this.verifyConnections();
        proxyConn.connect();
        this.verifyExpectedException(proxyConn.getResponseMessage());
    }

    private void verifyExpectedException(String exceptionMessage) {
        Assert.assertTrue((boolean)exceptionMessage.contains(ApplicationNotFoundException.class.getName()));
        Assert.assertTrue((boolean)exceptionMessage.contains("Application with id '" + this.fakeAppId + "' " + "doesn't exist in RM."));
    }
}

