/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.CancelDelegationTokenRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.RenewDelegationTokenRequestPBImpl;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.junit.Assert;
import org.junit.Test;

public class TestYarnApiClasses {
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @Test
    public void testResourceRequest() {
        Resource resource = (Resource)this.recordFactory.newRecordInstance(Resource.class);
        Priority priority = (Priority)this.recordFactory.newRecordInstance(Priority.class);
        ResourceRequest original = ResourceRequest.newInstance((Priority)priority, (String)"localhost", (Resource)resource, (int)2);
        ResourceRequest copy = ResourceRequest.newInstance((Priority)priority, (String)"localhost", (Resource)resource, (int)2);
        Assert.assertTrue((boolean)original.equals((Object)copy));
        Assert.assertEquals((long)0L, (long)original.compareTo(copy));
        Assert.assertTrue((original.hashCode() == copy.hashCode() ? 1 : 0) != 0);
        copy.setNumContainers(1);
        Assert.assertFalse((boolean)original.equals((Object)copy));
        Assert.assertNotSame((Object)0, (Object)original.compareTo(copy));
        Assert.assertFalse((original.hashCode() == copy.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testCancelDelegationTokenRequestPBImpl() {
        Token token = this.getDelegationToken();
        CancelDelegationTokenRequestPBImpl original = new CancelDelegationTokenRequestPBImpl();
        original.setDelegationToken(token);
        SecurityProtos.CancelDelegationTokenRequestProto protoType = original.getProto();
        CancelDelegationTokenRequestPBImpl copy = new CancelDelegationTokenRequestPBImpl(protoType);
        Assert.assertNotNull((Object)copy.getDelegationToken());
        Assert.assertEquals((Object)token, (Object)copy.getDelegationToken());
    }

    @Test
    public void testRenewDelegationTokenRequestPBImpl() {
        Token token = this.getDelegationToken();
        RenewDelegationTokenRequestPBImpl original = new RenewDelegationTokenRequestPBImpl();
        original.setDelegationToken(token);
        SecurityProtos.RenewDelegationTokenRequestProto protoType = original.getProto();
        RenewDelegationTokenRequestPBImpl copy = new RenewDelegationTokenRequestPBImpl(protoType);
        Assert.assertNotNull((Object)copy.getDelegationToken());
        Assert.assertEquals((Object)token, (Object)copy.getDelegationToken());
    }

    private Token getDelegationToken() {
        return Token.newInstance((byte[])new byte[0], (String)"", (byte[])new byte[0], (String)"");
    }
}

