/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.async.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.NMClientAsyncImpl;
import org.apache.hadoop.yarn.client.api.impl.NMClientImpl;
import org.apache.hadoop.yarn.ipc.RPCUtil;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NMClientAsyncImpl
extends NMClientAsync {
    private static final Log LOG = LogFactory.getLog(NMClientAsyncImpl.class);
    protected static final int INITIAL_THREAD_POOL_SIZE = 10;
    protected ThreadPoolExecutor threadPool;
    protected int maxThreadPoolSize;
    protected Thread eventDispatcherThread;
    protected AtomicBoolean stopped = new AtomicBoolean(false);
    protected BlockingQueue<ContainerEvent> events = new LinkedBlockingQueue();
    protected ConcurrentMap<ContainerId, StatefulContainer> containers = new ConcurrentHashMap();

    public NMClientAsyncImpl(NMClientAsync.CallbackHandler callbackHandler) {
        this(NMClientAsync.class.getName(), callbackHandler);
    }

    public NMClientAsyncImpl(String name, NMClientAsync.CallbackHandler callbackHandler) {
        this(name, (NMClient)new NMClientImpl(), callbackHandler);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected NMClientAsyncImpl(String name, NMClient client, NMClientAsync.CallbackHandler callbackHandler) {
        super(name, client, callbackHandler);
        this.client = client;
        this.callbackHandler = callbackHandler;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.maxThreadPoolSize = conf.getInt("yarn.client.nodemanager-client-async.thread-pool-max-size", 500);
        LOG.info((Object)("Upper bound of the thread pool size is " + this.maxThreadPoolSize));
        this.client.init(conf);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.client.start();
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat(this.getClass().getName() + " #%d").setDaemon(true).build();
        int initSize = Math.min(10, this.maxThreadPoolSize);
        this.threadPool = new ThreadPoolExecutor(initSize, Integer.MAX_VALUE, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), tf);
        this.eventDispatcherThread = new /* Unavailable Anonymous Inner Class!! */;
        this.eventDispatcherThread.setName("Container  Event Dispatcher");
        this.eventDispatcherThread.setDaemon(false);
        this.eventDispatcherThread.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        if (this.eventDispatcherThread != null) {
            this.eventDispatcherThread.interrupt();
            try {
                this.eventDispatcherThread.join();
            }
            catch (InterruptedException e) {
                LOG.error((Object)("The thread of " + this.eventDispatcherThread.getName() + " didn't finish normally."), (Throwable)e);
            }
        }
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
        if (this.client != null) {
            if ((!(this.client instanceof NMClientImpl) || ((NMClientImpl)this.client).getCleanupRunningContainers().get()) && this.containers != null) {
                this.containers.clear();
            }
            this.client.stop();
        }
        super.serviceStop();
    }

    public void startContainerAsync(Container container, ContainerLaunchContext containerLaunchContext) {
        if (this.containers.putIfAbsent(container.getId(), new StatefulContainer((NMClientAsync)this, container.getId())) != null) {
            this.callbackHandler.onStartContainerError(container.getId(), (Throwable)RPCUtil.getRemoteException((String)("Container " + container.getId() + " is already started or scheduled to start")));
        }
        try {
            this.events.put(new StartContainerEvent(container, containerLaunchContext));
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Exception when scheduling the event of starting Container " + container.getId()));
            this.callbackHandler.onStartContainerError(container.getId(), (Throwable)e);
        }
    }

    public void stopContainerAsync(ContainerId containerId, NodeId nodeId) {
        if (this.containers.get(containerId) == null) {
            this.callbackHandler.onStopContainerError(containerId, (Throwable)RPCUtil.getRemoteException((String)("Container " + containerId + " is neither started nor scheduled to start")));
        }
        try {
            this.events.put(new ContainerEvent(containerId, nodeId, null, ContainerEventType.STOP_CONTAINER));
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Exception when scheduling the event of stopping Container " + containerId));
            this.callbackHandler.onStopContainerError(containerId, (Throwable)e);
        }
    }

    public void getContainerStatusAsync(ContainerId containerId, NodeId nodeId) {
        try {
            this.events.put(new ContainerEvent(containerId, nodeId, null, ContainerEventType.QUERY_CONTAINER));
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Exception when scheduling the event of querying the status of Container " + containerId));
            this.callbackHandler.onGetContainerStatusError(containerId, (Throwable)e);
        }
    }

    protected boolean isCompletelyDone(StatefulContainer container) {
        return container.getState() == ContainerState.DONE || container.getState() == ContainerState.FAILED;
    }

    protected ContainerEventProcessor getContainerEventProcessor(ContainerEvent event) {
        return new ContainerEventProcessor(this, event);
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ NMClient access$200(NMClientAsyncImpl x0) {
        return x0.client;
    }

    static /* synthetic */ NMClientAsync.CallbackHandler access$300(NMClientAsyncImpl x0) {
        return x0.callbackHandler;
    }

    static /* synthetic */ NMClientAsync.CallbackHandler access$400(NMClientAsyncImpl x0) {
        return x0.callbackHandler;
    }
}

