/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.cli.TestLogsCLI;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.logaggregation.LogCLIHelpers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestLogsCLI {
    ByteArrayOutputStream sysOutStream;
    private PrintStream sysOut;
    ByteArrayOutputStream sysErrStream;
    private PrintStream sysErr;

    @Before
    public void setUp() {
        this.sysOutStream = new ByteArrayOutputStream();
        this.sysOut = new PrintStream(this.sysOutStream);
        System.setOut(this.sysOut);
        this.sysErrStream = new ByteArrayOutputStream();
        this.sysErr = new PrintStream(this.sysErrStream);
        System.setErr(this.sysErr);
    }

    @Test(timeout=5000L)
    public void testFailResultCodes() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("fs.file.impl", LocalFileSystem.class, FileSystem.class);
        LogCLIHelpers cliHelper = new LogCLIHelpers();
        cliHelper.setConf((Configuration)conf);
        YarnClient mockYarnClient = this.createMockYarnClient(YarnApplicationState.FINISHED);
        LogsCLIForTest dumper = new LogsCLIForTest(mockYarnClient);
        dumper.setConf((Configuration)conf);
        int exitCode = dumper.run(new String[]{"-applicationId", "application_0_0"});
        Assert.assertTrue((String)"Should return an error code", (exitCode != 0 ? 1 : 0) != 0);
        exitCode = cliHelper.dumpAContainersLogs("application_0_0", "container_0_0", "nonexistentnode:1234", "nobody");
        Assert.assertTrue((String)"Should return an error code", (exitCode != 0 ? 1 : 0) != 0);
    }

    @Test(timeout=5000L)
    public void testInvalidApplicationId() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        YarnClient mockYarnClient = this.createMockYarnClient(YarnApplicationState.FINISHED);
        LogsCLIForTest cli = new LogsCLIForTest(mockYarnClient);
        cli.setConf((Configuration)conf);
        int exitCode = cli.run(new String[]{"-applicationId", "not_an_app_id"});
        Assert.assertTrue((exitCode == -1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.sysErrStream.toString().startsWith("Invalid ApplicationId specified"));
    }

    @Test(timeout=5000L)
    public void testUnknownApplicationId() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        YarnClient mockYarnClient = this.createMockYarnClientUnknownApp();
        LogsCLIForTest cli = new LogsCLIForTest(mockYarnClient);
        cli.setConf((Configuration)conf);
        int exitCode = cli.run(new String[]{"-applicationId", ApplicationId.newInstance((long)1L, (int)1).toString()});
        Assert.assertTrue((exitCode != 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.sysErrStream.toString().startsWith("Unable to get ApplicationState"));
    }

    @Test(timeout=5000L)
    public void testHelpMessage() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        YarnClient mockYarnClient = this.createMockYarnClient(YarnApplicationState.FINISHED);
        LogsCLIForTest dumper = new LogsCLIForTest(mockYarnClient);
        dumper.setConf((Configuration)conf);
        int exitCode = dumper.run(new String[0]);
        Assert.assertTrue((exitCode == -1 ? 1 : 0) != 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("Retrieve logs for completed YARN applications.");
        pw.println("usage: yarn logs -applicationId <application ID> [OPTIONS]");
        pw.println();
        pw.println("general options are:");
        pw.println(" -appOwner <Application Owner>   AppOwner (assumed to be current user if");
        pw.println("                                 not specified)");
        pw.println(" -containerId <Container ID>     ContainerId (must be specified if node");
        pw.println("                                 address is specified)");
        pw.println(" -nodeAddress <Node Address>     NodeAddress in the format nodename:port");
        pw.println("                                 (must be specified if container id is");
        pw.println("                                 specified)");
        pw.close();
        String appReportStr = baos.toString("UTF-8");
        junit.framework.Assert.assertEquals((String)appReportStr, (String)this.sysOutStream.toString());
    }

    private YarnClient createMockYarnClient(YarnApplicationState appState) throws YarnException, IOException {
        YarnClient mockClient = (YarnClient)Mockito.mock(YarnClient.class);
        ApplicationReport mockAppReport = (ApplicationReport)Mockito.mock(ApplicationReport.class);
        ((ApplicationReport)Mockito.doReturn((Object)appState).when((Object)mockAppReport)).getYarnApplicationState();
        ((YarnClient)Mockito.doReturn((Object)mockAppReport).when((Object)mockClient)).getApplicationReport((ApplicationId)Matchers.any(ApplicationId.class));
        return mockClient;
    }

    private YarnClient createMockYarnClientUnknownApp() throws YarnException, IOException {
        YarnClient mockClient = (YarnClient)Mockito.mock(YarnClient.class);
        ((YarnClient)Mockito.doThrow((Throwable)new YarnException("Unknown AppId")).when((Object)mockClient)).getApplicationReport((ApplicationId)Matchers.any(ApplicationId.class));
        return mockClient;
    }
}

