/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.embedded;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.build.FusekiBuilder;
import org.apache.jena.fuseki.build.FusekiConfig;
import org.apache.jena.fuseki.jetty.FusekiErrorHandler1;
import org.apache.jena.fuseki.mgt.ActionStats;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.servlets.FusekiFilter;
import org.apache.jena.query.Dataset;
import org.apache.jena.sparql.core.DatasetGraph;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class FusekiEmbeddedServer {
    public final Server server;
    private int port;

    public static FusekiEmbeddedServer make(int port, String name, DatasetGraph dsg) {
        return FusekiEmbeddedServer.create().setPort(port).setLoopback(true).add(name, dsg).build();
    }

    public static Builder create() {
        return new Builder();
    }

    private FusekiEmbeddedServer(int port, Server server) {
        this.server = server;
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public Server getJettyServer() {
        return this.server;
    }

    public ServletContext getServletContext() {
        return ((ServletContextHandler)this.server.getHandler()).getServletContext();
    }

    public DataAccessPointRegistry getDataAccessPointRegistry() {
        return DataAccessPointRegistry.get((ServletContext)this.getServletContext());
    }

    public FusekiEmbeddedServer start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new FusekiException((Throwable)e);
        }
        if (this.port == 0) {
            this.port = ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
        }
        Fuseki.serverLog.info("Start Fuseki (port=" + this.port + ")");
        return this;
    }

    public void stop() {
        Fuseki.serverLog.info("Stop Fuseki (port=" + this.port + ")");
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new FusekiException((Throwable)e);
        }
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (Exception e) {
            throw new FusekiException((Throwable)e);
        }
    }

    public static class Builder {
        private Map<String, DataService> map = new HashMap<String, DataService>();
        private int port = 3330;
        private boolean loopback = false;
        private boolean withStats = false;
        private String contextPath = "/";

        public Builder setPort(int port) {
            if (port < 0) {
                throw new IllegalArgumentException("Illegal port=" + port + " : Port must be greater than or equal to zero.");
            }
            this.port = port;
            return this;
        }

        public Builder setContextPath(String path) {
            this.contextPath = path;
            return this;
        }

        public Builder setLoopback(boolean loopback) {
            this.loopback = loopback;
            return this;
        }

        public Builder enableStats(boolean withStats) {
            this.withStats = withStats;
            return this;
        }

        public Builder add(String name, Dataset ds) {
            return this.add(name, ds.asDatasetGraph());
        }

        public Builder add(String name, DatasetGraph dsg) {
            return this.add(name, dsg, true);
        }

        public Builder add(String name, Dataset ds, boolean allowUpdate) {
            return this.add(name, ds.asDatasetGraph(), allowUpdate);
        }

        public Builder add(String name, DatasetGraph dsg, boolean allowUpdate) {
            DataService dSrv = FusekiBuilder.buildDataService((DatasetGraph)dsg, (boolean)allowUpdate);
            return this.add(name, dSrv);
        }

        public Builder add(String name, DataService dataService) {
            return this.add$(name, dataService);
        }

        private Builder add$(String name, DataService dataService) {
            if (this.map.containsKey(name = DataAccessPoint.canonical((String)name))) {
                throw new FusekiConfigException("Data service name already registered: " + name);
            }
            this.map.put(name, dataService);
            return this;
        }

        public Builder parseConfigFile(String filename) {
            List x = FusekiConfig.readConfigurationFile((String)filename);
            x.forEach(dap -> this.add(dap.getName(), dap.getDataService()));
            return this;
        }

        public FusekiEmbeddedServer build() {
            DataAccessPointRegistry registry = new DataAccessPointRegistry();
            this.map.forEach((name, dSrv) -> {
                DataAccessPoint dap = new DataAccessPoint(name, dSrv);
                registry.put(name, (Object)dap);
            });
            ServletContextHandler handler = Builder.buildServletContext(this.contextPath, registry);
            if (this.withStats) {
                handler.addServlet(ActionStats.class, "/$/stats");
            }
            DataAccessPointRegistry.set((ServletContext)handler.getServletContext(), (DataAccessPointRegistry)registry);
            Server server = Builder.jettyServer(this.port, this.loopback);
            server.setHandler((Handler)handler);
            return new FusekiEmbeddedServer(this.port, server);
        }

        private static ServletContextHandler buildServletContext(String contextPath, DataAccessPointRegistry registry) {
            if (contextPath == null || contextPath.isEmpty()) {
                contextPath = "/";
            } else if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            ServletContextHandler context = new ServletContextHandler();
            FusekiFilter ff = new FusekiFilter();
            FilterHolder h = new FilterHolder((Filter)ff);
            context.setContextPath(contextPath);
            context.addFilter(h, "/*", null);
            context.setDisplayName(Fuseki.servletRequestLogName);
            context.setErrorHandler((ErrorHandler)new FusekiErrorHandler1());
            return context;
        }

        private static Server jettyServer(int port, boolean loopback) {
            Server server = new Server();
            HttpConnectionFactory f1 = new HttpConnectionFactory();
            f1.getHttpConfiguration().setRequestHeaderSize(524288);
            f1.getHttpConfiguration().setOutputBufferSize(0x500000);
            if (!Fuseki.outputJettyServerHeader) {
                f1.getHttpConfiguration().setSendServerVersion(false);
            }
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{f1});
            connector.setPort(port);
            server.addConnector((Connector)connector);
            if (loopback) {
                connector.setHost("localhost");
            }
            return server;
        }
    }
}

