/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.OptionChecker;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Mojo;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.apache.maven.plugin.compiler.Options;
import org.apache.maven.plugin.compiler.SourceDirectory;
import org.apache.maven.plugin.compiler.ToolExecutor;
import org.apache.maven.plugin.compiler.ToolExecutorForTest;

@Mojo(name="testCompile", defaultPhase="test-compile")
public class TestCompilerMojo
extends AbstractCompilerMojo {
    @Parameter(property="maven.test.skip")
    protected boolean skip;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/test-annotations")
    protected Path generatedTestSourcesDirectory;
    @Parameter
    protected Set<String> testIncludes;
    @Parameter
    protected Set<String> testExcludes;
    @Parameter
    protected Set<String> testIncrementalExcludes;
    @Parameter(property="maven.compiler.testSource")
    protected String testSource;
    @Parameter(property="maven.compiler.testTarget")
    protected String testTarget;
    @Parameter(property="maven.compiler.testRelease")
    protected String testRelease;
    @Parameter
    protected List<String> testCompilerArgs;
    @Parameter
    @Deprecated(since="4.0.0")
    protected Map<String, String> testCompilerArguments;
    @Parameter
    @Deprecated(since="4.0.0")
    protected String testCompilerArgument;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    protected Path outputDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    protected Path mainOutputDirectory;
    @Deprecated(since="4.0.0")
    @Parameter(defaultValue="true")
    protected boolean useModulePath = true;
    @Deprecated(since="4.0.0")
    transient boolean hasTestModuleInfo;
    private transient boolean hasMainModuleInfo;
    transient Path mainModulePath;
    @Parameter(defaultValue="javac-test.args")
    protected String debugFileName;

    public TestCompilerMojo() {
        super(PathScope.TEST_COMPILE);
    }

    @Override
    public void execute() throws MojoException {
        if (this.skip) {
            this.logger.info((CharSequence)"Not compiling test sources");
            return;
        }
        super.execute();
    }

    @Override
    public Options parseParameters(OptionChecker compiler) {
        Options configuration = super.parseParameters(compiler);
        configuration.addUnchecked((Iterable<String>)(this.testCompilerArgs == null || this.testCompilerArgs.isEmpty() ? this.compilerArgs : this.testCompilerArgs));
        if (this.testCompilerArguments != null) {
            for (Map.Entry<String, String> entry : this.testCompilerArguments.entrySet()) {
                configuration.addUnchecked(List.of(entry.getKey(), entry.getValue()));
            }
        }
        configuration.addUnchecked(this.testCompilerArgument == null ? this.compilerArgument : this.testCompilerArgument);
        return configuration;
    }

    @Override
    @Nullable
    protected Path getGeneratedSourcesDirectory() {
        return this.generatedTestSourcesDirectory;
    }

    @Override
    protected Set<String> getIncludes() {
        return this.testIncludes != null ? this.testIncludes : Set.of();
    }

    @Override
    protected Set<String> getExcludes() {
        return this.testExcludes != null ? this.testExcludes : Set.of();
    }

    @Override
    protected Set<String> getIncrementalExcludes() {
        return this.testIncrementalExcludes != null ? this.testIncrementalExcludes : Set.of();
    }

    @Override
    @Nullable
    protected String getSource() {
        return this.testSource == null ? this.source : this.testSource;
    }

    @Override
    @Nullable
    protected String getTarget() {
        return this.testTarget == null ? this.target : this.testTarget;
    }

    @Override
    @Nullable
    protected String getRelease() {
        return this.testRelease == null ? this.release : this.testRelease;
    }

    @Override
    @Nonnull
    protected Path getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    @Nullable
    protected String getDebugFileName() {
        return this.debugFileName;
    }

    final String getTestModuleName(List<SourceDirectory> compileSourceRoots) throws IOException {
        for (SourceDirectory directory : compileSourceRoots) {
            if (directory.moduleName != null) {
                return directory.moduleName;
            }
            String name = this.parseModuleInfoName(directory.getModuleInfo().orElse(null));
            if (name == null) continue;
            return name;
        }
        return null;
    }

    @Override
    final boolean hasModuleDeclaration(List<SourceDirectory> roots) throws IOException {
        for (SourceDirectory root : roots) {
            this.hasMainModuleInfo |= root.moduleName != null;
            this.hasTestModuleInfo |= root.getModuleInfo().isPresent();
            if (!(this.hasMainModuleInfo & this.hasTestModuleInfo)) continue;
            break;
        }
        if (this.hasTestModuleInfo) {
            MessageBuilder message = this.messageBuilderFactory.builder();
            message.a((CharSequence)"Overwriting the ").warning((Object)"module-info.java").a((CharSequence)" file in the test directory is deprecated. Use ").info((Object)"module-info-patch.maven").a((CharSequence)" instead.");
            this.logger.warn((CharSequence)message.toString());
            return this.useModulePath;
        }
        return this.useModulePath && this.hasMainModuleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ToolExecutor createExecutor(DiagnosticListener<? super JavaFileObject> listener) throws IOException {
        try {
            Path file = this.mainOutputDirectory.resolve("module-info.class");
            if (Files.isRegularFile(file, new LinkOption[0])) {
                this.mainModulePath = file;
                this.hasMainModuleInfo = true;
            }
            ToolExecutorForTest toolExecutorForTest = new ToolExecutorForTest(this, listener);
            return toolExecutorForTest;
        }
        finally {
            this.hasTestModuleInfo = false;
            this.hasMainModuleInfo = false;
            this.mainModulePath = null;
        }
    }
}

