/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.toolchain.jdk;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.toolchain.jdk.ToolchainDiscoverer;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.io.xpp3.MavenToolchainsXpp3Writer;

@Mojo(name="generate-jdk-toolchains-xml", requiresProject=false)
public class GenerateJdkToolchainsXmlMojo
extends AbstractMojo {
    @Parameter(property="toolchain.file")
    String file;
    @Inject
    ToolchainDiscoverer discoverer;

    public void execute() throws MojoFailureException {
        block15: {
            try {
                PersistedToolchains toolchains = this.discoverer.discoverToolchains();
                if (this.file != null) {
                    Path file = Paths.get(this.file, new String[0]).toAbsolutePath();
                    Files.createDirectories(file.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
                        new MavenToolchainsXpp3Writer().write((Writer)writer, toolchains);
                        break block15;
                    }
                }
                StringWriter writer = new StringWriter();
                new MavenToolchainsXpp3Writer().write((Writer)writer, toolchains);
                System.out.println(writer);
            }
            catch (IOException e) {
                throw new MojoFailureException("Unable to generate toolchains.xml", (Throwable)e);
            }
        }
    }
}

