/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib;

import java.io.File;
import java.io.IOException;
import org.apache.maven.scm.ScmTestCase;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Assert;

public final class CvsScmTestUtils {
    public static final String CVS_COMMAND_LINE = "cvs";

    private CvsScmTestUtils() {
    }

    public static String getScmUrl(File repository, String module) {
        return "scm:cvs|local|" + repository + "|" + module;
    }

    public static void executeCVS(File workingDirectory, String arguments) throws Exception {
        ScmTestCase.execute((File)workingDirectory, (String)CVS_COMMAND_LINE, (String)arguments);
    }

    public static void initRepo(File repository, File workingDirectory, File assertionDirectory) throws IOException {
        CvsScmTestUtils.initRepo("src/test/repository/", repository, workingDirectory);
        FileUtils.deleteDirectory((File)assertionDirectory);
        Assert.assertTrue((boolean)assertionDirectory.mkdirs());
    }

    public static void initRepo(String source, File repository, File workingDirectory) throws IOException {
        File src = PlexusTestCase.getTestFile((String)source);
        FileUtils.deleteDirectory((File)repository);
        Assert.assertTrue((boolean)repository.mkdirs());
        FileUtils.copyDirectoryStructure((File)src, (File)repository);
        FileUtils.deleteDirectory((File)workingDirectory);
        Assert.assertTrue((boolean)workingDirectory.mkdirs());
    }
}

