/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.changelog;

import java.util.Date;
import org.apache.maven.scm.ScmTestCase;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.cvslib.AbstractCvsScmTest;
import org.apache.maven.scm.provider.cvslib.CvsScmTestUtils;

public class CvsChangeLogCommandTest
extends AbstractCvsScmTest {
    protected String getModule() {
        return "test-repo/changelog";
    }

    public void testGetCommandWithStartAndEndDate() throws Exception {
        Date startDate = CvsChangeLogCommandTest.getDate((int)2003, (int)1, (int)1);
        Date endDate = CvsChangeLogCommandTest.getDate((int)2004, (int)1, (int)1);
        this.testChangeLog(startDate, endDate, 32, null);
    }

    public void testGetCommandWithoutEndDate() throws Exception {
        Date startDate = CvsChangeLogCommandTest.getDate((int)2003, (int)1, (int)1);
        Date endDate = null;
        this.testChangeLog(startDate, endDate, 51, null);
    }

    public void testGetCommandWithBranchOrTag() throws Exception {
        Date startDate = null;
        Date endDate = null;
        this.testChangeLog(startDate, endDate, 22, "1.107.4");
    }

    private void testChangeLog(Date startDate, Date endDate, int changeLogSize, String branch) throws Exception {
        if (!CvsChangeLogCommandTest.isSystemCmd((String)"cvs")) {
            ScmTestCase.printSystemCmdUnavail((String)"cvs", (String)this.getName());
            return;
        }
        ScmManager scmManager = this.getScmManager();
        CvsScmTestUtils.executeCVS(this.getWorkingDirectory(), "-f -d " + CvsChangeLogCommandTest.getTestFile((String)"src/test/repository/") + " co " + this.getModule());
        ChangeLogScmResult changeLogResult = scmManager.getProviderByRepository(this.getScmRepository()).changeLog(this.getScmRepository(), this.getScmFileSet(), startDate, endDate, 0, branch);
        if (!changeLogResult.isSuccess()) {
            CvsChangeLogCommandTest.fail((String)(changeLogResult.getProviderMessage() + "\n" + changeLogResult.getCommandOutput()));
        }
        ChangeLogSet changeLogSet = changeLogResult.getChangeLog();
        CvsChangeLogCommandTest.assertNotNull((Object)changeLogSet);
        CvsChangeLogCommandTest.assertEquals((int)changeLogSize, (int)changeLogSet.getChangeSets().size());
    }
}

