/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.api.model.BalanceShardUniqueRequestBody;
import org.apache.solr.client.api.model.CreateCollectionRequestBody;
import org.apache.solr.client.api.model.CreateCollectionRouterProperties;
import org.apache.solr.client.api.model.ListCollectionsResponse;
import org.apache.solr.client.api.model.ReloadCollectionRequestBody;
import org.apache.solr.client.api.model.RenameCollectionRequestBody;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for collections, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class CollectionsApi {

  public static class BalanceShardUniqueResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse> {
    public BalanceShardUniqueResponse() {
      super(org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse.class);
    }
  }

  public static class BalanceShardUnique extends SolrRequest<BalanceShardUniqueResponse> {
    private final BalanceShardUniqueRequestBody requestBody;
    private final String collectionName;

    /**
     * Create a BalanceShardUnique request object.
     *
     * @param collectionName Path param -
     */
    public BalanceShardUnique(String collectionName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/collections/{collectionName}/balance-shard-unique"
              .replace("{" + "collectionName" + "}", collectionName));

      this.collectionName = collectionName;
      this.requestBody = new BalanceShardUniqueRequestBody();
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setProperty(String property) {
      this.requestBody.property = property;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setOnlyActiveNodes(Boolean onlyActiveNodes) {
      this.requestBody.onlyActiveNodes = onlyActiveNodes;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setShardUnique(Boolean shardUnique) {
      this.requestBody.shardUnique = shardUnique;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
      // v2 only supports JSON request bodies, so we ignore this type coming from the RequestWriter
      return new JacksonContentWriter(requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected BalanceShardUniqueResponse createResponse(SolrClient client) {
      return new BalanceShardUniqueResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class CreateCollectionResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse> {
    public CreateCollectionResponse() {
      super(org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse.class);
    }
  }

  public static class CreateCollection extends SolrRequest<CreateCollectionResponse> {
    private final CreateCollectionRequestBody requestBody;

    /** Create a CreateCollection request object. */
    public CreateCollection() {
      super(SolrRequest.METHOD.valueOf("POST"), "/collections");

      this.requestBody = new CreateCollectionRequestBody();
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setName(String name) {
      this.requestBody.name = name;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setReplicationFactor(Integer replicationFactor) {
      this.requestBody.replicationFactor = replicationFactor;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setConfig(String config) {
      this.requestBody.config = config;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setNumShards(Integer numShards) {
      this.requestBody.numShards = numShards;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setShardNames(List<String> shardNames) {
      this.requestBody.shardNames = shardNames;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setPullReplicas(Integer pullReplicas) {
      this.requestBody.pullReplicas = pullReplicas;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setTlogReplicas(Integer tlogReplicas) {
      this.requestBody.tlogReplicas = tlogReplicas;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setNrtReplicas(Integer nrtReplicas) {
      this.requestBody.nrtReplicas = nrtReplicas;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setWaitForFinalState(Boolean waitForFinalState) {
      this.requestBody.waitForFinalState = waitForFinalState;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setPerReplicaState(Boolean perReplicaState) {
      this.requestBody.perReplicaState = perReplicaState;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setAlias(String alias) {
      this.requestBody.alias = alias;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setProperties(Map<String, String> properties) {
      this.requestBody.properties = properties;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setRouter(CreateCollectionRouterProperties router) {
      this.requestBody.router = router;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setNodeSet(List<String> nodeSet) {
      this.requestBody.nodeSet = nodeSet;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setCreateReplicas(Boolean createReplicas) {
      this.requestBody.createReplicas = createReplicas;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setShuffleNodes(Boolean shuffleNodes) {
      this.requestBody.shuffleNodes = shuffleNodes;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
      // v2 only supports JSON request bodies, so we ignore this type coming from the RequestWriter
      return new JacksonContentWriter(requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected CreateCollectionResponse createResponse(SolrClient client) {
      return new CreateCollectionResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class DeleteCollectionResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse> {
    public DeleteCollectionResponse() {
      super(org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse.class);
    }
  }

  public static class DeleteCollection extends SolrRequest<DeleteCollectionResponse> {
    private final String collectionName;
    private Boolean followAliases;
    private String async;

    /**
     * Create a DeleteCollection request object.
     *
     * @param collectionName Path param - The name of the collection to be deleted.
     */
    public DeleteCollection(String collectionName) {
      super(
          SolrRequest.METHOD.valueOf("DELETE"),
          "/collections/{collectionName}".replace("{" + "collectionName" + "}", collectionName));

      this.collectionName = collectionName;
    }

    public void setFollowAliases(Boolean followAliases) {
      this.followAliases = followAliases;
    }

    /**
     * @param async An ID to track the request asynchronously
     */
    public void setAsync(String async) {
      this.async = async;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (followAliases != null) {

        params.add("followAliases", followAliases.toString());
      }
      if (async != null) {

        params.add("async", async);
      }
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      queryParams.add("followAliases");
      queryParams.add("async");
      return queryParams;
    }

    @Override
    protected DeleteCollectionResponse createResponse(SolrClient client) {
      return new DeleteCollectionResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetCollectionStatusResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.CollectionStatusResponse> {
    public GetCollectionStatusResponse() {
      super(org.apache.solr.client.api.model.CollectionStatusResponse.class);
    }
  }

  public static class GetCollectionStatus extends SolrRequest<GetCollectionStatusResponse> {
    private final String collectionName;
    private Boolean coreInfo;
    private Boolean segments;
    private Boolean fieldInfo;
    private Boolean rawSize;
    private Boolean rawSizeSummary;
    private Boolean rawSizeDetails;
    private Float rawSizeSamplingPercent;
    private Boolean sizeInfo;

    /**
     * Create a GetCollectionStatus request object.
     *
     * @param collectionName Path param - The name of the collection return metadata for
     */
    public GetCollectionStatus(String collectionName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/collections/{collectionName}".replace("{" + "collectionName" + "}", collectionName));

      this.collectionName = collectionName;
    }

    /**
     * @param coreInfo Boolean flag to include metadata (e.g. index an data directories, IndexWriter
     *     configuration, etc.) about each shard leader&#39;s core
     */
    public void setCoreInfo(Boolean coreInfo) {
      this.coreInfo = coreInfo;
    }

    /**
     * @param segments Boolean flag to include metadata and statistics about the segments used by
     *     each shard leader. Implicitly set to true by &#39;fieldInfo&#39; and &#39;sizeInfo&#39;
     */
    public void setSegments(Boolean segments) {
      this.segments = segments;
    }

    /**
     * @param fieldInfo Boolean flag to include statistics about the indexed fields present on each
     *     shard leader. Implicitly sets the &#39;segments&#39; flag to &#39;true&#39;
     */
    public void setFieldInfo(Boolean fieldInfo) {
      this.fieldInfo = fieldInfo;
    }

    /**
     * @param rawSize Boolean flag to include simple estimates of the disk size taken up by each
     *     field (e.g. \&quot;id\&quot;, \&quot;_version_\&quot;) and by each index data structure
     *     (e.g. &#39;storedFields&#39;, &#39;docValues_numeric&#39;).
     */
    public void setRawSize(Boolean rawSize) {
      this.rawSize = rawSize;
    }

    /**
     * @param rawSizeSummary Boolean flag to include more involved estimates of the disk size taken
     *     up by index data structures, on a per-field basis (e.g. how much data does the
     *     \&quot;id\&quot; field contribute to &#39;storedField&#39; index files). More detail than
     *     &#39;rawSize&#39;, less detail than &#39;rawSizeDetails&#39;.
     */
    public void setRawSizeSummary(Boolean rawSizeSummary) {
      this.rawSizeSummary = rawSizeSummary;
    }

    /**
     * @param rawSizeDetails Boolean flag to include detailed statistics about the disk size taken
     *     up by various fields and data structures. More detail than &#39;rawSize&#39; and
     *     &#39;rawSizeSummary&#39;.
     */
    public void setRawSizeDetails(Boolean rawSizeDetails) {
      this.rawSizeDetails = rawSizeDetails;
    }

    /**
     * @param rawSizeSamplingPercent Percentage (between 0 and 100) of data to read when estimating
     *     index size and statistics. Defaults to 5.0 (i.e. 5%).
     */
    public void setRawSizeSamplingPercent(Float rawSizeSamplingPercent) {
      this.rawSizeSamplingPercent = rawSizeSamplingPercent;
    }

    /**
     * @param sizeInfo Boolean flag to include information about the largest index files for each
     *     Lucene segment.. Implicitly sets the &#39;segment&#39; flag to &#39;true&#39;
     */
    public void setSizeInfo(Boolean sizeInfo) {
      this.sizeInfo = sizeInfo;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (coreInfo != null) {

        params.add("coreInfo", coreInfo.toString());
      }
      if (segments != null) {

        params.add("segments", segments.toString());
      }
      if (fieldInfo != null) {

        params.add("fieldInfo", fieldInfo.toString());
      }
      if (rawSize != null) {

        params.add("rawSize", rawSize.toString());
      }
      if (rawSizeSummary != null) {

        params.add("rawSizeSummary", rawSizeSummary.toString());
      }
      if (rawSizeDetails != null) {

        params.add("rawSizeDetails", rawSizeDetails.toString());
      }
      if (rawSizeSamplingPercent != null) {

        params.add("rawSizeSamplingPercent", rawSizeSamplingPercent.toString());
      }
      if (sizeInfo != null) {

        params.add("sizeInfo", sizeInfo.toString());
      }
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      queryParams.add("coreInfo");
      queryParams.add("segments");
      queryParams.add("fieldInfo");
      queryParams.add("rawSize");
      queryParams.add("rawSizeSummary");
      queryParams.add("rawSizeDetails");
      queryParams.add("rawSizeSamplingPercent");
      queryParams.add("sizeInfo");
      return queryParams;
    }

    @Override
    protected GetCollectionStatusResponse createResponse(SolrClient client) {
      return new GetCollectionStatusResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ListCollectionsResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.ListCollectionsResponse> {
    public ListCollectionsResponse() {
      super(org.apache.solr.client.api.model.ListCollectionsResponse.class);
    }
  }

  public static class ListCollections extends SolrRequest<ListCollectionsResponse> {

    /** Create a ListCollections request object. */
    public ListCollections() {
      super(SolrRequest.METHOD.valueOf("GET"), "/collections");
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected ListCollectionsResponse createResponse(SolrClient client) {
      return new ListCollectionsResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ReloadCollectionResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse> {
    public ReloadCollectionResponse() {
      super(org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse.class);
    }
  }

  public static class ReloadCollection extends SolrRequest<ReloadCollectionResponse> {
    private final ReloadCollectionRequestBody requestBody;
    private final String collectionName;

    /**
     * Create a ReloadCollection request object.
     *
     * @param collectionName Path param -
     */
    public ReloadCollection(String collectionName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/collections/{collectionName}/reload"
              .replace("{" + "collectionName" + "}", collectionName));

      this.collectionName = collectionName;
      this.requestBody = new ReloadCollectionRequestBody();
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
      // v2 only supports JSON request bodies, so we ignore this type coming from the RequestWriter
      return new JacksonContentWriter(requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected ReloadCollectionResponse createResponse(SolrClient client) {
      return new ReloadCollectionResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class RenameCollectionResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse> {
    public RenameCollectionResponse() {
      super(org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse.class);
    }
  }

  public static class RenameCollection extends SolrRequest<RenameCollectionResponse> {
    private final RenameCollectionRequestBody requestBody;
    private final String collectionName;

    /**
     * Create a RenameCollection request object.
     *
     * @param collectionName Path param -
     */
    public RenameCollection(String collectionName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/collections/{collectionName}/rename"
              .replace("{" + "collectionName" + "}", collectionName));

      this.collectionName = collectionName;
      this.requestBody = new RenameCollectionRequestBody();
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setTo(String to) {
      this.requestBody.to = to;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setFollowAliases(Boolean followAliases) {
      this.requestBody.followAliases = followAliases;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
      // v2 only supports JSON request bodies, so we ignore this type coming from the RequestWriter
      return new JacksonContentWriter(requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected RenameCollectionResponse createResponse(SolrClient client) {
      return new RenameCollectionResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
