/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.api.model.CloneConfigsetRequestBody;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for configsets, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class ConfigsetsApi {

  public static class CloneExistingConfigSetResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public CloneExistingConfigSetResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class CloneExistingConfigSet extends SolrRequest<CloneExistingConfigSetResponse> {
    private final CloneConfigsetRequestBody requestBody;

    /** Create a CloneExistingConfigSet request object. */
    public CloneExistingConfigSet() {
      super(SolrRequest.METHOD.valueOf("POST"), "/configsets");

      this.requestBody = new CloneConfigsetRequestBody();
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setName(String name) {
      this.requestBody.name = name;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setBaseConfigSet(String baseConfigSet) {
      this.requestBody.baseConfigSet = baseConfigSet;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setProperties(Map<String, Object> properties) {
      this.requestBody.properties = properties;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
      // v2 only supports JSON request bodies, so we ignore this type coming from the RequestWriter
      return new JacksonContentWriter(requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected CloneExistingConfigSetResponse createResponse(SolrClient client) {
      return new CloneExistingConfigSetResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class DeleteConfigSetResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public DeleteConfigSetResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class DeleteConfigSet extends SolrRequest<DeleteConfigSetResponse> {
    private final String configSetName;

    /**
     * Create a DeleteConfigSet request object.
     *
     * @param configSetName Path param -
     */
    public DeleteConfigSet(String configSetName) {
      super(
          SolrRequest.METHOD.valueOf("DELETE"),
          "/configsets/{configSetName}".replace("{" + "configSetName" + "}", configSetName));

      this.configSetName = configSetName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected DeleteConfigSetResponse createResponse(SolrClient client) {
      return new DeleteConfigSetResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ListConfigSetResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.ListConfigsetsResponse> {
    public ListConfigSetResponse() {
      super(org.apache.solr.client.api.model.ListConfigsetsResponse.class);
    }
  }

  public static class ListConfigSet extends SolrRequest<ListConfigSetResponse> {

    /** Create a ListConfigSet request object. */
    public ListConfigSet() {
      super(SolrRequest.METHOD.valueOf("GET"), "/configsets");
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected ListConfigSetResponse createResponse(SolrClient client) {
      return new ListConfigSetResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class UploadConfigSetResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public UploadConfigSetResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class UploadConfigSet extends SolrRequest<UploadConfigSetResponse> {
    private final Object requestBody;
    private final String configSetName;
    private Boolean overwrite;
    private Boolean cleanup;

    /**
     * Create a UploadConfigSet request object.
     *
     * @param configSetName Path param -
     */
    public UploadConfigSet(String configSetName) {
      super(
          SolrRequest.METHOD.valueOf("PUT"),
          "/configsets/{configSetName}".replace("{" + "configSetName" + "}", configSetName));

      this.configSetName = configSetName;
      this.requestBody = new HashMap<>();
    }

    public void setOverwrite(Boolean overwrite) {
      this.overwrite = overwrite;
    }

    public void setCleanup(Boolean cleanup) {
      this.cleanup = cleanup;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
      // v2 only supports JSON request bodies, so we ignore this type coming from the RequestWriter
      return new JacksonContentWriter(requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (overwrite != null) {

        params.add("overwrite", overwrite.toString());
      }
      if (cleanup != null) {

        params.add("cleanup", cleanup.toString());
      }
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      queryParams.add("overwrite");
      queryParams.add("cleanup");
      return queryParams;
    }

    @Override
    protected UploadConfigSetResponse createResponse(SolrClient client) {
      return new UploadConfigSetResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class UploadConfigSetFileResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public UploadConfigSetFileResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class UploadConfigSetFile extends SolrRequest<UploadConfigSetFileResponse> {
    private final Object requestBody;
    private final String configSetName;
    private final String filePath;
    private Boolean overwrite;
    private Boolean cleanup;

    /**
     * Create a UploadConfigSetFile request object.
     *
     * @param configSetName Path param -
     * @param filePath Path param -
     */
    public UploadConfigSetFile(String configSetName, String filePath) {
      super(
          SolrRequest.METHOD.valueOf("PUT"),
          "/configsets/{configSetName}/{filePath}"
              .replace("{" + "configSetName" + "}", configSetName)
              .replace("{" + "filePath" + "}", filePath));

      this.configSetName = configSetName;
      this.filePath = filePath;
      this.requestBody = new HashMap<>();
    }

    public void setOverwrite(Boolean overwrite) {
      this.overwrite = overwrite;
    }

    public void setCleanup(Boolean cleanup) {
      this.cleanup = cleanup;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
      // v2 only supports JSON request bodies, so we ignore this type coming from the RequestWriter
      return new JacksonContentWriter(requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (overwrite != null) {

        params.add("overwrite", overwrite.toString());
      }
      if (cleanup != null) {

        params.add("cleanup", cleanup.toString());
      }
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      queryParams.add("overwrite");
      queryParams.add("cleanup");
      return queryParams;
    }

    @Override
    protected UploadConfigSetFileResponse createResponse(SolrClient client) {
      return new UploadConfigSetFileResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
