/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.solrj.InputStreamResponse;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for replication, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class ReplicationApi {

  public static class FetchFile1Response extends InputStreamResponse {}

  public static class FetchFile1 extends SolrRequest<FetchFile1Response> {
    private final String coreName;
    private final String filePath;
    private final String dirType;
    private String offset;
    private String len;
    private Boolean compression;
    private Boolean checksum;
    private Double maxWriteMBPerSec;
    private Long generation;

    /**
     * Create a FetchFile1 request object.
     *
     * @param coreName Path param -
     * @param filePath Path param -
     * @param dirType Path param - Directory type for specific filePath (cf or tlogFile). Defaults
     *     to Lucene index (file) directory if empty
     */
    public FetchFile1(String coreName, String filePath, String dirType) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/cores/{coreName}/replication/files/{filePath}"
              .replace("{" + "coreName" + "}", coreName)
              .replace("{" + "filePath" + "}", filePath));

      this.coreName = coreName;
      this.filePath = filePath;
      this.dirType = dirType;
    }

    /**
     * @param offset Output stream read/write offset
     */
    public void setOffset(String offset) {
      this.offset = offset;
    }

    public void setLen(String len) {
      this.len = len;
    }

    /**
     * @param compression Compress file output
     */
    public void setCompression(Boolean compression) {
      this.compression = compression;
    }

    /**
     * @param checksum Write checksum with output stream
     */
    public void setChecksum(Boolean checksum) {
      this.checksum = checksum;
    }

    /**
     * @param maxWriteMBPerSec Limit data write per seconds. Defaults to no throttling
     */
    public void setMaxWriteMBPerSec(Double maxWriteMBPerSec) {
      this.maxWriteMBPerSec = maxWriteMBPerSec;
    }

    /**
     * @param generation The generation number of the index
     */
    public void setGeneration(Long generation) {
      this.generation = generation;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (dirType != null) {

        params.add("dirType", dirType);
      }
      if (offset != null) {

        params.add("offset", offset);
      }
      if (len != null) {

        params.add("len", len);
      }
      if (compression != null) {

        params.add("compression", compression.toString());
      }
      if (checksum != null) {

        params.add("checksum", checksum.toString());
      }
      if (maxWriteMBPerSec != null) {

        params.add("maxWriteMBPerSec", maxWriteMBPerSec.toString());
      }
      if (generation != null) {

        params.add("generation", generation.toString());
      }
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      queryParams.add("dirType");
      queryParams.add("offset");
      queryParams.add("len");
      queryParams.add("compression");
      queryParams.add("checksum");
      queryParams.add("maxWriteMBPerSec");
      queryParams.add("generation");
      return queryParams;
    }

    @Override
    protected FetchFile1Response createResponse(SolrClient client) {
      return new FetchFile1Response();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class FetchFileListResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.FileListResponse> {
    public FetchFileListResponse() {
      super(org.apache.solr.client.api.model.FileListResponse.class);
    }
  }

  public static class FetchFileList extends SolrRequest<FetchFileListResponse> {
    private final String coreName;
    private final Long generation;

    /**
     * Create a FetchFileList request object.
     *
     * @param coreName Path param -
     * @param generation Path param - The generation number of the index
     */
    public FetchFileList(String coreName, Long generation) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/cores/{coreName}/replication/files".replace("{" + "coreName" + "}", coreName));

      this.coreName = coreName;
      this.generation = generation;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (generation != null) {

        params.add("generation", generation.toString());
      }
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      queryParams.add("generation");
      return queryParams;
    }

    @Override
    protected FetchFileListResponse createResponse(SolrClient client) {
      return new FetchFileListResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class FetchIndexVersionResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.IndexVersionResponse> {
    public FetchIndexVersionResponse() {
      super(org.apache.solr.client.api.model.IndexVersionResponse.class);
    }
  }

  public static class FetchIndexVersion extends SolrRequest<FetchIndexVersionResponse> {
    private final String coreName;

    /**
     * Create a FetchIndexVersion request object.
     *
     * @param coreName Path param -
     */
    public FetchIndexVersion(String coreName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/cores/{coreName}/replication/indexversion".replace("{" + "coreName" + "}", coreName));

      this.coreName = coreName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected FetchIndexVersionResponse createResponse(SolrClient client) {
      return new FetchIndexVersionResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
