/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.request.IsUpdateRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class LBSolrClient
extends SolrClient {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String UPDATE_LIVE_SERVER_MESSAGE = "Updated alive server list";
    private static final String UPDATE_LIVE_SERVER_LOG = "Updated alive server list for {}: {}";
    protected static final Set<Integer> RETRY_CODES = new HashSet<Integer>(Arrays.asList(404, 403, 503, 500));
    private static final int NONSTANDARD_PING_LIMIT = 5;
    private final Map<String, ServerWrapper> allServers = new LinkedHashMap<String, ServerWrapper>();
    protected final Map<String, ServerWrapper> zombieServers = new ConcurrentHashMap<String, ServerWrapper>();
    private volatile ServerWrapper[] aliveServerList = new ServerWrapper[0];
    private volatile ScheduledExecutorService aliveCheckExecutor;
    protected long aliveCheckIntervalMillis = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private final AtomicInteger counter = new AtomicInteger(-1);
    private static final SolrQuery solrQuery = new SolrQuery("*:*");
    protected volatile ResponseParser parser;
    protected volatile RequestWriter requestWriter;

    public LBSolrClient(List<String> baseSolrUrls) {
        if (!baseSolrUrls.isEmpty()) {
            for (String s : baseSolrUrls) {
                ServerWrapper wrapper = this.createServerWrapper(s);
                this.allServers.put(wrapper.getBaseUrl(), wrapper);
            }
            this.updateAliveList();
        }
        ObjectReleaseTracker.track(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAliveList() {
        Map<String, ServerWrapper> map = this.allServers;
        synchronized (map) {
            this.aliveServerList = (ServerWrapper[])this.allServers.values().stream().filter(server -> !this.zombieServers.containsKey(server.baseUrl)).toArray(ServerWrapper[]::new);
            if (log.isDebugEnabled()) {
                log.debug(UPDATE_LIVE_SERVER_LOG, (Object)this, (Object)Arrays.toString(this.aliveServerList));
            }
        }
    }

    protected ServerWrapper createServerWrapper(String baseUrl) {
        if (this.allServers.containsKey(baseUrl)) {
            return this.allServers.get(baseUrl);
        }
        return new ServerWrapper(baseUrl);
    }

    public static String normalize(String server) {
        if (server.endsWith("/")) {
            server = server.substring(0, server.length() - 1);
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rsp request(Req req) throws SolrServerException, IOException {
        String serverStr;
        Rsp rsp = new Rsp();
        Exception ex = null;
        boolean isNonRetryable = req.request instanceof IsUpdateRequest || CommonParams.ADMIN_PATHS.contains(req.request.getPath());
        ServerIterator serverIterator = new ServerIterator(req, this.zombieServers);
        while ((serverStr = serverIterator.nextOrError(ex)) != null) {
            try {
                MDC.put((String)"LBSolrClient.url", (String)serverStr);
                ex = this.doRequest(serverStr, req, rsp, isNonRetryable, serverIterator.isServingZombieServer());
                if (ex != null) continue;
                Rsp rsp2 = rsp;
                return rsp2;
            }
            finally {
                MDC.remove((String)"LBSolrClient.url");
            }
        }
        throw new SolrServerException("No live SolrServers available to handle this request. (Tracking " + this.zombieServers.size() + " not live)", ex);
    }

    private static long getTimeAllowedInNanos(SolrRequest<?> req) {
        SolrParams reqParams = req.getParams();
        return reqParams == null ? -1L : TimeUnit.NANOSECONDS.convert(reqParams.getInt("timeAllowed", -1), TimeUnit.MILLISECONDS);
    }

    private static boolean isTimeExceeded(long timeAllowedNano, long timeOutTime) {
        return timeAllowedNano > 0L && System.nanoTime() > timeOutTime;
    }

    protected Exception doRequest(String baseUrl, Req req, Rsp rsp, boolean isNonRetryable, boolean isZombie) throws SolrServerException, IOException {
        Exception ex = null;
        try {
            rsp.server = baseUrl;
            rsp.rsp = this.doRequest(baseUrl, req.getRequest(), null);
            if (isZombie) {
                this.reviveZombieServer(baseUrl);
            }
        }
        catch (BaseHttpSolrClient.RemoteExecutionException e) {
            throw e;
        }
        catch (SolrException e) {
            if (!isNonRetryable && RETRY_CODES.contains(e.code())) {
                ex = !isZombie ? this.makeServerAZombie(baseUrl, e) : e;
            }
            if (isZombie) {
                this.reviveZombieServer(baseUrl);
            }
            throw e;
        }
        catch (SocketException e) {
            if (!isNonRetryable || e instanceof ConnectException) {
                ex = !isZombie ? this.makeServerAZombie(baseUrl, e) : e;
            }
            throw e;
        }
        catch (SocketTimeoutException e) {
            if (!isNonRetryable) {
                ex = !isZombie ? this.makeServerAZombie(baseUrl, e) : e;
            }
            throw e;
        }
        catch (SolrServerException e) {
            Throwable rootCause = e.getRootCause();
            if (!isNonRetryable && rootCause instanceof IOException) {
                ex = !isZombie ? this.makeServerAZombie(baseUrl, e) : e;
            }
            if (isNonRetryable && rootCause instanceof ConnectException) {
                ex = !isZombie ? this.makeServerAZombie(baseUrl, e) : e;
            }
            throw e;
        }
        catch (Exception e) {
            throw new SolrServerException(e);
        }
        return ex;
    }

    protected NamedList<Object> doRequest(String baseUrl, SolrRequest<?> solrRequest, String collection) throws SolrServerException, IOException {
        SolrClient solrClient = this.getClient(baseUrl);
        if (solrClient instanceof Http2SolrClient) {
            Http2SolrClient httpSolrClient = (Http2SolrClient)solrClient;
            return httpSolrClient.requestWithBaseUrl(baseUrl, c -> c.request(solrRequest, collection));
        }
        return solrClient.request(solrRequest, collection);
    }

    protected abstract SolrClient getClient(String var1);

    protected abstract SolrClient getClient(Endpoint var1);

    @Deprecated
    public void setAliveCheckInterval(int aliveCheckIntervalMillis) {
        if (aliveCheckIntervalMillis <= 0) {
            throw new IllegalArgumentException("Alive check interval must be positive, specified value = " + aliveCheckIntervalMillis);
        }
        this.aliveCheckIntervalMillis = aliveCheckIntervalMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAliveCheckExecutor() {
        if (this.aliveCheckExecutor == null) {
            LBSolrClient lBSolrClient = this;
            synchronized (lBSolrClient) {
                if (this.aliveCheckExecutor == null) {
                    log.debug("Starting aliveCheckExecutor for {}", (Object)this);
                    this.aliveCheckExecutor = Executors.newSingleThreadScheduledExecutor(new SolrNamedThreadFactory("aliveCheckExecutor"));
                    this.aliveCheckExecutor.scheduleAtFixedRate(LBSolrClient.getAliveCheckRunner(new WeakReference<LBSolrClient>(this)), this.aliveCheckIntervalMillis, this.aliveCheckIntervalMillis, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private static Runnable getAliveCheckRunner(WeakReference<LBSolrClient> lbRef) {
        return () -> {
            LBSolrClient lb = (LBSolrClient)lbRef.get();
            if (lb != null && lb.zombieServers != null) {
                for (ServerWrapper zombieServer : lb.zombieServers.values()) {
                    lb.checkAZombieServer(zombieServer);
                }
            }
        };
    }

    public ResponseParser getParser() {
        return this.parser;
    }

    @Deprecated
    public void setParser(ResponseParser parser) {
        this.parser = parser;
    }

    @Deprecated
    public void setRequestWriter(RequestWriter requestWriter) {
        this.requestWriter = requestWriter;
    }

    public RequestWriter getRequestWriter() {
        return this.requestWriter;
    }

    private void checkAZombieServer(ServerWrapper zombieServer) {
        block3: {
            try {
                log.debug("Checking zombie server {} for {}", (Object)zombieServer, (Object)this);
                QueryRequest queryRequest = new QueryRequest(solrQuery);
                NamedList<Object> responseRaw = this.doRequest(zombieServer.getBaseUrl(), queryRequest, null);
                QueryResponse resp = new QueryResponse();
                resp.setResponse(responseRaw);
                if (resp.getStatus() == 0) {
                    this.reviveZombieServer(zombieServer);
                }
            }
            catch (Exception e) {
                ++zombieServer.failedPings;
                if (this.allServers.containsKey(zombieServer.getBaseUrl()) || zombieServer.failedPings < 5) break block3;
                this.reviveZombieServer(zombieServer);
            }
        }
    }

    protected synchronized void reviveZombieServer(String endpoint) {
        ServerWrapper server = this.zombieServers.remove(endpoint);
        if (server != null && this.allServers.containsKey(endpoint)) {
            server.failedPings = 0;
            this.updateAliveList();
        }
    }

    protected synchronized void reviveZombieServer(ServerWrapper wrapper) {
        this.reviveZombieServer(wrapper.getBaseUrl());
    }

    protected synchronized void makeServerAZombie(ServerWrapper wrapper) {
        if (this.zombieServers.putIfAbsent(wrapper.getBaseUrl(), wrapper) == null) {
            this.updateAliveList();
        }
        this.startAliveCheckExecutor();
    }

    protected void makeServerAZombie(String endpoint) {
        this.makeServerAZombie(this.createServerWrapper(endpoint));
    }

    protected Exception makeServerAZombie(String endpoint, Exception e) {
        this.makeServerAZombie(endpoint);
        return e;
    }

    @Deprecated
    public synchronized void addSolrServer(String server) throws MalformedURLException {
        ServerWrapper prev = this.allServers.put(server, this.createServerWrapper(server));
        this.updateAliveList();
    }

    public void addSolrServer(Endpoint server) throws MalformedURLException {
        this.addSolrServer(server.getUrl());
    }

    @Deprecated
    public synchronized String removeSolrServer(String server) {
        if ((server = URI.create(server).toString()).endsWith("/")) {
            server = server.substring(0, server.length() - 1);
        }
        this.allServers.remove(server);
        this.zombieServers.remove(server);
        this.updateAliveList();
        return null;
    }

    public String removeSolrEndpoint(Endpoint endpoint) {
        return this.removeSolrServer(endpoint.getUrl());
    }

    @Override
    public NamedList<Object> request(SolrRequest<?> request, String collection) throws SolrServerException, IOException {
        return this.request(request, collection, null);
    }

    public NamedList<Object> request(SolrRequest<?> request, String collection, Integer numServersToTry) throws SolrServerException, IOException {
        Exception ex = null;
        ServerWrapper[] serverList = this.aliveServerList;
        int maxTries = numServersToTry == null ? serverList.length : numServersToTry;
        int numServersTried = 0;
        HashMap<String, ServerWrapper> justFailed = null;
        if (ClientUtils.shouldApplyDefaultCollection(collection, request)) {
            collection = this.defaultCollection;
        }
        boolean timeAllowedExceeded = false;
        long timeAllowedNano = LBSolrClient.getTimeAllowedInNanos(request);
        long timeOutTime = System.nanoTime() + timeAllowedNano;
        for (int attempts = 0; attempts < maxTries && !(timeAllowedExceeded = LBSolrClient.isTimeExceeded(timeAllowedNano, timeOutTime)); ++attempts) {
            ServerWrapper wrapper = this.pickServer(serverList, request);
            try {
                ++numServersTried;
                return this.doRequest(wrapper.getBaseUrl(), request, collection);
            }
            catch (SolrException e) {
                throw e;
            }
            catch (SolrServerException e) {
                if (e.getRootCause() instanceof IOException) {
                    ex = e;
                    this.makeServerAZombie(wrapper);
                    if (justFailed == null) {
                        justFailed = new HashMap();
                    }
                    justFailed.put(wrapper.getBaseUrl(), wrapper);
                    continue;
                }
                throw e;
            }
            catch (IOException e) {
                ex = e;
                this.makeServerAZombie(wrapper);
                if (justFailed == null) {
                    justFailed = new HashMap<String, ServerWrapper>();
                }
                justFailed.put(wrapper.getBaseUrl(), wrapper);
                continue;
            }
            catch (Exception e) {
                throw new SolrServerException(e);
            }
        }
        for (ServerWrapper wrapper : this.zombieServers.values()) {
            timeAllowedExceeded = LBSolrClient.isTimeExceeded(timeAllowedNano, timeOutTime);
            if (timeAllowedExceeded) break;
            if (!this.allServers.containsKey(wrapper.getBaseUrl()) || justFailed != null && justFailed.containsKey(wrapper.getBaseUrl())) continue;
            try {
                ++numServersTried;
                NamedList<Object> rsp = this.doRequest(wrapper.baseUrl, request, collection);
                this.reviveZombieServer(wrapper);
                return rsp;
            }
            catch (SolrException e) {
                this.reviveZombieServer(wrapper);
                throw e;
            }
            catch (SolrServerException e) {
                if (e.getRootCause() instanceof IOException) {
                    ex = e;
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                throw new SolrServerException(e);
            }
        }
        Object solrServerExceptionMessage = timeAllowedExceeded ? "Time allowed to handle this request exceeded" : (numServersToTry != null && numServersTried > numServersToTry ? "No live SolrServers available to handle this request: numServersTried=" + numServersTried + " numServersToTry=" + numServersToTry : "No live SolrServers available to handle this request");
        if (ex == null) {
            throw new SolrServerException((String)solrServerExceptionMessage);
        }
        throw new SolrServerException((String)solrServerExceptionMessage, ex);
    }

    protected ServerWrapper pickServer(ServerWrapper[] aliveServerList, SolrRequest<?> request) {
        int count = this.counter.incrementAndGet() & Integer.MAX_VALUE;
        return aliveServerList[count % aliveServerList.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LBSolrClient lBSolrClient = this;
        synchronized (lBSolrClient) {
            if (this.aliveCheckExecutor != null) {
                ExecutorUtil.shutdownNowAndAwaitTermination(this.aliveCheckExecutor);
            }
        }
        ObjectReleaseTracker.release(this);
    }

    static {
        solrQuery.setRows(0);
        solrQuery.setSort("_docid_", SolrQuery.ORDER.asc);
        solrQuery.setDistrib(false);
    }

    public static class Rsp {
        protected String server;
        protected NamedList<Object> rsp;

        public NamedList<Object> getResponse() {
            return this.rsp;
        }

        public String getServer() {
            return this.server;
        }
    }

    public static class Req {
        protected SolrRequest<?> request;
        protected List<String> servers;
        protected int numDeadServersToTry;
        private final Integer numServersToTry;

        @Deprecated
        public Req(SolrRequest<?> request, List<String> servers) {
            this(request, servers, (Integer)null);
        }

        public Req(SolrRequest<?> request, Collection<Endpoint> servers) {
            this(request, servers.stream().map(endpoint -> endpoint.getUrl()).collect(Collectors.toList()));
        }

        @Deprecated
        public Req(SolrRequest<?> request, List<String> servers, Integer numServersToTry) {
            this.request = request;
            this.servers = servers;
            this.numDeadServersToTry = servers.size();
            this.numServersToTry = numServersToTry;
        }

        public Req(SolrRequest<?> request, Collection<Endpoint> servers, Integer numServersToTry) {
            this(request, servers.stream().map(endpoint -> endpoint.getUrl()).collect(Collectors.toList()), numServersToTry);
        }

        public SolrRequest<?> getRequest() {
            return this.request;
        }

        @Deprecated
        public List<String> getServers() {
            return this.servers;
        }

        public int getNumDeadServersToTry() {
            return this.numDeadServersToTry;
        }

        public void setNumDeadServersToTry(int numDeadServersToTry) {
            this.numDeadServersToTry = numDeadServersToTry;
        }

        public Integer getNumServersToTry() {
            return this.numServersToTry;
        }
    }

    protected static class ServerIterator {
        String serverStr;
        List<String> skipped;
        int numServersTried;
        Iterator<String> it;
        Iterator<String> skippedIt;
        String exceptionMessage;
        long timeAllowedNano;
        long timeOutTime;
        final Map<String, ServerWrapper> zombieServers;
        final Req req;

        public ServerIterator(Req req, Map<String, ServerWrapper> zombieServers) {
            this.it = req.getServers().iterator();
            this.req = req;
            this.zombieServers = zombieServers;
            this.timeAllowedNano = LBSolrClient.getTimeAllowedInNanos(req.getRequest());
            this.timeOutTime = System.nanoTime() + this.timeAllowedNano;
            this.fetchNext();
        }

        public synchronized boolean hasNext() {
            return this.serverStr != null;
        }

        private void fetchNext() {
            this.serverStr = null;
            if (this.req.numServersToTry != null && this.numServersTried > this.req.numServersToTry) {
                this.exceptionMessage = "Time allowed to handle this request exceeded";
                return;
            }
            while (this.it.hasNext()) {
                this.serverStr = this.it.next();
                this.serverStr = LBSolrClient.normalize(this.serverStr);
                ServerWrapper wrapper = this.zombieServers.get(this.serverStr);
                if (wrapper == null) break;
                int numDeadServersToTry = this.req.getNumDeadServersToTry();
                if (numDeadServersToTry <= 0) continue;
                if (this.skipped == null) {
                    this.skipped = new ArrayList<String>(numDeadServersToTry);
                    this.skipped.add(wrapper.getBaseUrl());
                    continue;
                }
                if (this.skipped.size() >= numDeadServersToTry) continue;
                this.skipped.add(wrapper.getBaseUrl());
            }
            if (this.serverStr == null && this.skipped != null) {
                if (this.skippedIt == null) {
                    this.skippedIt = this.skipped.iterator();
                }
                if (this.skippedIt.hasNext()) {
                    this.serverStr = this.skippedIt.next();
                }
            }
        }

        boolean isServingZombieServer() {
            return this.skippedIt != null;
        }

        public synchronized String nextOrError() throws SolrServerException {
            return this.nextOrError(null);
        }

        public synchronized String nextOrError(Exception previousEx) throws SolrServerException {
            Object suffix = "";
            if (previousEx == null) {
                suffix = ":" + this.zombieServers.keySet();
            }
            if (previousEx != null && previousEx.getMessage() != null && previousEx.getMessage().contains("Limits exceeded!") || this.numServersTried > 0 && LBSolrClient.isTimeExceeded(this.timeAllowedNano, this.timeOutTime)) {
                throw new SolrServerException("The processing limits for to this request were exceeded, see cause for details", previousEx);
            }
            if (this.serverStr == null) {
                throw new SolrServerException("No live SolrServers available to handle this request" + (String)suffix, previousEx);
            }
            ++this.numServersTried;
            if (this.req.getNumServersToTry() != null && this.numServersTried > this.req.getNumServersToTry()) {
                throw new SolrServerException("No live SolrServers available to handle this request: numServersTried=" + this.numServersTried + " numServersToTry=" + this.req.getNumServersToTry() + (String)suffix, previousEx);
            }
            String rs = this.serverStr;
            this.fetchNext();
            return rs;
        }
    }

    protected static class ServerWrapper {
        final String baseUrl;
        int failedPings = 0;

        ServerWrapper(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String toString() {
            return this.baseUrl;
        }

        public int hashCode() {
            return this.baseUrl.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ServerWrapper)) {
                return false;
            }
            return this.baseUrl.equals(((ServerWrapper)obj).baseUrl);
        }
    }

    public static class Endpoint {
        private final String baseUrl;
        private final String core;

        public Endpoint(String baseUrl) {
            this(baseUrl, null);
        }

        public Endpoint(String baseUrl, String core) {
            this.baseUrl = LBSolrClient.normalize(baseUrl);
            this.core = core;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String getCore() {
            return this.core;
        }

        public String getUrl() {
            if (this.core == null) {
                return this.baseUrl;
            }
            return this.baseUrl + "/" + this.core;
        }

        public String toString() {
            return this.getUrl();
        }

        public int hashCode() {
            return Objects.hash(this.baseUrl, this.core);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Endpoint)) {
                return false;
            }
            Endpoint rhs = (Endpoint)obj;
            return Objects.equals(this.baseUrl, rhs.baseUrl) && Objects.equals(this.core, rhs.core);
        }
    }
}

