/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;

public class AttributeTable {
    private Hashtable attributes = new Hashtable();

    public AttributeTable(Hashtable hashtable) {
        this.attributes = new Hashtable(hashtable);
    }

    public AttributeTable(ASN1Set aSN1Set) {
        int n = 0;
        while (n != aSN1Set.size()) {
            Attribute attribute = Attribute.getInstance(aSN1Set.getObjectAt(n));
            this.attributes.put(attribute.getAttrType(), attribute);
            ++n;
        }
    }

    public AttributeTable(DEREncodableVector dEREncodableVector) {
        int n = 0;
        while (n != dEREncodableVector.size()) {
            Attribute attribute = Attribute.getInstance(dEREncodableVector.get(n));
            this.attributes.put(attribute.getAttrType(), attribute);
            ++n;
        }
    }

    public Attribute get(DERObjectIdentifier dERObjectIdentifier) {
        return (Attribute)this.attributes.get(dERObjectIdentifier);
    }

    public Hashtable toHashtable() {
        return new Hashtable(this.attributes);
    }
}

