/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;

public abstract class X509NameEntryConverter {
    protected boolean canBePrintable(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            char c = string.charAt(n);
            if (string.charAt(n) > '\u007f') {
                return false;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                switch (c) {
                    default: {
                        return false;
                    }
                    case ' ': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case ':': 
                    case '=': 
                    case '?': 
                }
            }
            --n;
        }
        return true;
    }

    protected boolean canBeUTF8(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            if (string.charAt(n) > '\u00ff') {
                return false;
            }
            --n;
        }
        return true;
    }

    protected DERObject convertHexEncoded(String string, int n) throws IOException {
        string = string.toLowerCase();
        byte[] byArray = new byte[string.length() / 2];
        int n2 = 0;
        while (n2 != byArray.length) {
            char c = string.charAt(n2 * 2 + n);
            char c2 = string.charAt(n2 * 2 + n + 1);
            byArray[n2] = c < 'a' ? (byte)(c - 48 << 4) : (byte)(c - 97 + 10 << 4);
            if (c2 < 'a') {
                int n3 = n2;
                byArray[n3] = (byte)(byArray[n3] | (byte)(c2 - 48));
            } else {
                int n4 = n2;
                byArray[n4] = (byte)(byArray[n4] | (byte)(c2 - 97 + 10));
            }
            ++n2;
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
        return aSN1InputStream.readObject();
    }

    public abstract DERObject getConvertedValue(DERObjectIdentifier var1, String var2);
}

