/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public class RC6Engine
implements BlockCipher {
    private static final int wordSize = 32;
    private static final int bytesPerWord = 4;
    private static final int _noRounds = 20;
    private int[] _S = null;
    private static final int P32 = -1209970333;
    private static final int Q32 = -1640531527;
    private static final int LGW = 5;
    private boolean forEncryption;

    private int bytesToWord(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 3;
        while (n3 >= 0) {
            n2 = (n2 << 8) + (byArray[n3 + n] & 0xFF);
            --n3;
        }
        return n2;
    }

    private int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.bytesToWord(byArray, n);
        int n4 = this.bytesToWord(byArray, n + 4);
        int n5 = this.bytesToWord(byArray, n + 8);
        int n6 = this.bytesToWord(byArray, n + 12);
        n5 -= this._S[43];
        n3 -= this._S[42];
        int n7 = 20;
        while (n7 >= 1) {
            int n8 = 0;
            int n9 = 0;
            int n10 = n6;
            n6 = n5;
            n5 = n4;
            n4 = n3;
            n3 = n10;
            n8 = n4 * (2 * n4 + 1);
            n8 = this.rotateLeft(n8, 5);
            n9 = n6 * (2 * n6 + 1);
            n9 = this.rotateLeft(n9, 5);
            n5 -= this._S[2 * n7 + 1];
            n5 = this.rotateRight(n5, n8);
            n5 ^= n9;
            n3 -= this._S[2 * n7];
            n3 = this.rotateRight(n3, n9);
            n3 ^= n8;
            --n7;
        }
        this.wordToBytes(n3, byArray2, n2);
        this.wordToBytes(n4 -= this._S[0], byArray2, n2 + 4);
        this.wordToBytes(n5, byArray2, n2 + 8);
        this.wordToBytes(n6 -= this._S[1], byArray2, n2 + 12);
        return 16;
    }

    private int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.bytesToWord(byArray, n);
        int n4 = this.bytesToWord(byArray, n + 4);
        int n5 = this.bytesToWord(byArray, n + 8);
        int n6 = this.bytesToWord(byArray, n + 12);
        n4 += this._S[0];
        n6 += this._S[1];
        int n7 = 1;
        while (n7 <= 20) {
            int n8 = 0;
            int n9 = 0;
            n8 = n4 * (2 * n4 + 1);
            n8 = this.rotateLeft(n8, 5);
            n9 = n6 * (2 * n6 + 1);
            n9 = this.rotateLeft(n9, 5);
            n3 ^= n8;
            n3 = this.rotateLeft(n3, n9);
            n5 ^= n9;
            n5 = this.rotateLeft(n5, n8);
            int n10 = n3 += this._S[2 * n7];
            n3 = n4;
            n4 = n5 += this._S[2 * n7 + 1];
            n5 = n6;
            n6 = n10;
            ++n7;
        }
        this.wordToBytes(n3 += this._S[42], byArray2, n2);
        this.wordToBytes(n4, byArray2, n2 + 4);
        this.wordToBytes(n5 += this._S[43], byArray2, n2 + 8);
        this.wordToBytes(n6, byArray2, n2 + 12);
        return 16;
    }

    public String getAlgorithmName() {
        return "RC6";
    }

    public int getBlockSize() {
        return 16;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to RC6 init - " + cipherParameters.getClass().getName());
        }
        KeyParameter keyParameter = (KeyParameter)cipherParameters;
        this.forEncryption = bl;
        this.setKey(keyParameter.getKey());
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        return this.forEncryption ? this.encryptBlock(byArray, n, byArray2, n2) : this.decryptBlock(byArray, n, byArray2, n2);
    }

    public void reset() {
    }

    private int rotateLeft(int n, int n2) {
        return n << (n2 & 0x1F) | n >>> 32 - (n2 & 0x1F);
    }

    private int rotateRight(int n, int n2) {
        return n >>> (n2 & 0x1F) | n << 32 - (n2 & 0x1F);
    }

    private void setKey(byte[] byArray) {
        int n = (byArray.length + 3) / 4;
        if (n == 0) {
            n = 1;
        }
        int[] nArray = new int[(byArray.length + 4 - 1) / 4];
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            nArray[n2 / 4] = (nArray[n2 / 4] << 8) + (byArray[n2] & 0xFF);
            --n2;
        }
        this._S = new int[44];
        this._S[0] = -1209970333;
        int n3 = 1;
        while (n3 < this._S.length) {
            this._S[n3] = this._S[n3 - 1] + -1640531527;
            ++n3;
        }
        int n4 = nArray.length > this._S.length ? 3 * nArray.length : 3 * this._S.length;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n4) {
            n5 = this._S[n7] = this.rotateLeft(this._S[n7] + n5 + n6, 3);
            n6 = nArray[n8] = this.rotateLeft(nArray[n8] + n5 + n6, n5 + n6);
            n7 = (n7 + 1) % this._S.length;
            n8 = (n8 + 1) % nArray.length;
            ++n9;
        }
    }

    private void wordToBytes(int n, byte[] byArray, int n2) {
        int n3 = 0;
        while (n3 < 4) {
            byArray[n3 + n2] = (byte)n;
            n >>>= 8;
            ++n3;
        }
    }
}

