/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private DSAKeyGenerationParameters param;

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        DSAParameters dSAParameters = this.param.getParameters();
        SecureRandom secureRandom = this.param.getRandom();
        BigInteger bigInteger2 = dSAParameters.getQ();
        BigInteger bigInteger3 = dSAParameters.getP();
        BigInteger bigInteger4 = dSAParameters.getG();
        while ((bigInteger = new BigInteger(160, secureRandom)).equals(ZERO) || bigInteger.compareTo(bigInteger2) >= 0) {
        }
        BigInteger bigInteger5 = bigInteger4.modPow(bigInteger, bigInteger3);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(bigInteger5, dSAParameters), new DSAPrivateKeyParameters(bigInteger, dSAParameters));
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DSAKeyGenerationParameters)keyGenerationParameters;
    }
}

