/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECPoint;

public class ECDSASigner
implements ECConstants,
DSA {
    ECKeyParameters key;
    SecureRandom random;

    public BigInteger[] generateSignature(byte[] byArray) {
        Object object;
        BigInteger[] bigIntegerArray;
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = this.key.getParameters().getN();
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        do {
            BigInteger bigInteger5;
            bigIntegerArray = null;
            int n = bigInteger2.bitLength();
            while ((bigIntegerArray = new BigInteger(n, this.random)).equals(ECConstants.ZERO) || (bigInteger3 = (bigInteger5 = ((ECPoint)(object = this.key.getParameters().getG().multiply((BigInteger)bigIntegerArray))).getX().toBigInteger()).mod(bigInteger2)).equals(ECConstants.ZERO)) {
            }
            object = ((ECPrivateKeyParameters)this.key).getD();
        } while ((bigInteger4 = bigIntegerArray.modInverse(bigInteger2).multiply(bigInteger.add(((BigInteger)object).multiply(bigInteger3))).mod(bigInteger2)).equals(ECConstants.ZERO));
        bigIntegerArray = new BigInteger[]{bigInteger3, bigInteger4};
        return bigIntegerArray;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.random = parametersWithRandom.getRandom();
                this.key = (ECPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (ECPrivateKeyParameters)cipherParameters;
            }
        } else {
            this.key = (ECPublicKeyParameters)cipherParameters;
        }
    }

    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = new BigInteger(1, byArray);
        BigInteger bigInteger4 = this.key.getParameters().getN();
        if (bigInteger.compareTo(ECConstants.ONE) < 0 || bigInteger.compareTo(bigInteger4) >= 0) {
            return false;
        }
        if (bigInteger2.compareTo(ECConstants.ONE) < 0 || bigInteger2.compareTo(bigInteger4) >= 0) {
            return false;
        }
        BigInteger bigInteger5 = bigInteger2.modInverse(bigInteger4);
        BigInteger bigInteger6 = bigInteger3.multiply(bigInteger5).mod(bigInteger4);
        BigInteger bigInteger7 = bigInteger.multiply(bigInteger5).mod(bigInteger4);
        ECPoint eCPoint = this.key.getParameters().getG();
        ECPoint eCPoint2 = ((ECPublicKeyParameters)this.key).getQ();
        ECPoint eCPoint3 = eCPoint.multiply(bigInteger6).add(eCPoint2.multiply(bigInteger7));
        BigInteger bigInteger8 = eCPoint3.getX().toBigInteger().mod(bigInteger4);
        return bigInteger8.equals(bigInteger);
    }
}

