/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import org.bouncycastle.asn1.pkcs.CertBag;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedData;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.MacData;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Pfx;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.SafeBag;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.jce.interfaces.BCKeyStore;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.jce.provider.JCEPBEKey;
import org.bouncycastle.jce.provider.JDKKeyFactory;
import org.bouncycastle.util.encoders.Hex;

public class JDKPKCS12KeyStore
extends KeyStoreSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers,
BCKeyStore {
    private static final int SALT_SIZE = 20;
    private static final int MIN_ITERATIONS = 100;
    private static final String KEY_ALGORITHM = "1.2.840.113549.1.12.1.3";
    private static final String CERT_ALGORITHM = "1.2.840.113549.1.12.1.6";
    private Hashtable keys = new Hashtable();
    private Hashtable localIds = new Hashtable();
    private Hashtable certs = new Hashtable();
    private Hashtable chainCerts = new Hashtable();
    private Hashtable keyCerts = new Hashtable();
    static final int NULL = 0;
    static final int CERTIFICATE = 1;
    static final int KEY = 2;
    static final int SECRET = 3;
    static final int SEALED = 4;
    static final int KEY_PRIVATE = 0;
    static final int KEY_PUBLIC = 1;
    static final int KEY_SECRET = 2;
    protected SecureRandom random = new SecureRandom();
    private CertificateFactory certFact = null;

    public JDKPKCS12KeyStore(String string) {
        try {
            this.certFact = string != null ? CertificateFactory.getInstance("X.509", string) : CertificateFactory.getInstance("X.509");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("can't create cert factory - " + exception.toString());
        }
    }

    private SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(byteArrayInputStream).readObject());
            return new SubjectKeyIdentifier(subjectPublicKeyInfo);
        }
        catch (Exception exception) {
            throw new RuntimeException("error creating key");
        }
    }

    protected ASN1Sequence decryptData(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, char[] cArray, boolean bl) throws IOException {
        Object object;
        String string = algorithmIdentifier.getObjectId().getId();
        PKCS12PBEParams pKCS12PBEParams = new PKCS12PBEParams((ASN1Sequence)algorithmIdentifier.getParameters());
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        byte[] byArray2 = null;
        try {
            object = SecretKeyFactory.getInstance(string, "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            SecretKey secretKey = ((SecretKeyFactory)object).generateSecret(pBEKeySpec);
            ((JCEPBEKey)secretKey).setTryWrongPKCS12Zero(bl);
            Cipher cipher = Cipher.getInstance(string, "BC");
            cipher.init(2, (Key)secretKey, pBEParameterSpec);
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new IOException("exception decrypting data - " + exception.toString());
        }
        object = new ASN1InputStream(new ByteArrayInputStream(byArray2));
        return (ASN1Sequence)((ASN1InputStream)object).readObject();
    }

    protected byte[] encryptData(String string, byte[] byArray, PKCS12PBEParams pKCS12PBEParams, char[] cArray) throws IOException {
        byte[] byArray2;
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            Cipher cipher = Cipher.getInstance(string, "BC");
            cipher.init(1, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new IOException("exception encrypting data - " + exception.toString());
        }
        return byArray2;
    }

    public Enumeration engineAliases() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.certs.get(string) != null || this.keys.get(string) != null;
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        Key key = (Key)this.keys.remove(string);
        Certificate certificate = (Certificate)this.certs.remove(string);
        if (certificate != null) {
            this.chainCerts.remove(new CertId(certificate.getPublicKey()));
        }
        if (key != null) {
            String string2 = (String)this.localIds.remove(string);
            if (string2 != null) {
                certificate = (Certificate)this.keyCerts.remove(string2);
            }
            if (certificate != null) {
                this.chainCerts.remove(new CertId(certificate.getPublicKey()));
            }
        }
        if (certificate == null && key == null) {
            throw new KeyStoreException("no such entry as " + string);
        }
    }

    public Certificate engineGetCertificate(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getCertificate.");
        }
        Certificate certificate = (Certificate)this.certs.get(string);
        if (certificate == null) {
            String string2 = (String)this.localIds.get(string);
            certificate = string2 != null ? (Certificate)this.keyCerts.get(string2) : (Certificate)this.keyCerts.get(string);
        }
        return certificate;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.certs.elements();
        Enumeration enumeration2 = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2 = (Certificate)enumeration.nextElement();
            String string = (String)enumeration2.nextElement();
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getCertificateChain.");
        }
        if (!this.engineIsKeyEntry(string)) {
            return null;
        }
        Certificate certificate = this.engineGetCertificate(string);
        if (certificate != null) {
            Certificate[] certificateArray;
            Vector<Certificate> vector = new Vector<Certificate>();
            while (certificate != null) {
                Object object;
                Object object2;
                Object object3;
                certificateArray = (Certificate[])certificate;
                Certificate certificate2 = null;
                byte[] byArray = certificateArray.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
                if (byArray != null) {
                    try {
                        object3 = new ByteArrayInputStream(byArray);
                        object2 = new ASN1InputStream((InputStream)object3);
                        object3 = new ByteArrayInputStream(((ASN1OctetString)((ASN1InputStream)object2).readObject()).getOctets());
                        object2 = new ASN1InputStream((InputStream)object3);
                        object = new AuthorityKeyIdentifier((ASN1Sequence)((ASN1InputStream)object2).readObject());
                        if (((AuthorityKeyIdentifier)object).getKeyIdentifier() != null) {
                            certificate2 = (Certificate)this.chainCerts.get(new CertId(((AuthorityKeyIdentifier)object).getKeyIdentifier()));
                        }
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException.toString());
                    }
                }
                if (certificate2 == null && !(object3 = certificateArray.getIssuerDN()).equals(object2 = certificateArray.getSubjectDN())) {
                    object = this.chainCerts.keys();
                    while (object.hasMoreElements()) {
                        X509Certificate x509Certificate = (X509Certificate)this.chainCerts.get(object.nextElement());
                        Principal principal = x509Certificate.getSubjectDN();
                        if (!principal.equals(object3)) continue;
                        try {
                            certificateArray.verify(x509Certificate.getPublicKey());
                            certificate2 = x509Certificate;
                            break;
                        }
                        catch (Exception exception) {}
                    }
                }
                vector.addElement(certificate);
                certificate = certificate2 != certificate ? certificate2 : null;
            }
            certificateArray = new Certificate[vector.size()];
            int n = 0;
            while (n != certificateArray.length) {
                certificateArray[n] = (Certificate)vector.elementAt(n);
                ++n;
            }
            return certificateArray;
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        return new Date();
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getKey.");
        }
        return (Key)this.keys.get(string);
    }

    public boolean engineIsCertificateEntry(String string) {
        return this.certs.get(string) != null && this.keys.get(string) == null;
    }

    public boolean engineIsKeyEntry(String string) {
        return this.keys.get(string) != null;
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        Object object12;
        if (inputStream == null) {
            return;
        }
        if (cArray == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(10);
        int n = bufferedInputStream.read();
        if (n != 48) {
            throw new IOException("stream does not represent a PKCS12 key store");
        }
        bufferedInputStream.reset();
        ASN1InputStream aSN1InputStream = new ASN1InputStream(bufferedInputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        Pfx pfx = new Pfx(aSN1Sequence);
        ContentInfo contentInfo = pfx.getAuthSafe();
        Vector<SafeBag> vector = new Vector<SafeBag>();
        boolean bl = false;
        boolean bl2 = false;
        if (pfx.getMacData() != null) {
            object12 = new ByteArrayOutputStream();
            object11 = new BEROutputStream((OutputStream)object12);
            MacData macData = pfx.getMacData();
            object10 = macData.getMac();
            object9 = ((DigestInfo)object10).getAlgorithmId();
            byte[] byArray = macData.getSalt();
            int n2 = macData.getIterationCount().intValue();
            ((BEROutputStream)object11).writeObject(contentInfo);
            object8 = ((ASN1OctetString)contentInfo.getContent()).getOctets();
            try {
                object7 = Mac.getInstance(((AlgorithmIdentifier)object9).getObjectId().getId(), "BC");
                object6 = SecretKeyFactory.getInstance(((AlgorithmIdentifier)object9).getObjectId().getId(), "BC");
                object5 = new PBEParameterSpec(byArray, n2);
                object4 = new PBEKeySpec(cArray);
                ((Mac)object7).init(((SecretKeyFactory)object6).generateSecret((KeySpec)object4), (AlgorithmParameterSpec)object5);
                ((Mac)object7).update((byte[])object8);
                object3 = ((Mac)object7).doFinal();
                object2 = ((DigestInfo)object10).getDigest();
                if (((byte[])object3).length != ((DigestInfo)object10).getDigest().length) {
                    throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                }
                boolean bl3 = true;
                int n3 = 0;
                while (n3 != ((byte[])object3).length) {
                    if (object3[n3] != object2[n3]) {
                        if (cArray.length != 0) {
                            throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                        }
                        bl3 = false;
                        break;
                    }
                    ++n3;
                }
                if (!bl3) {
                    object = ((SecretKeyFactory)object6).generateSecret((KeySpec)object4);
                    ((JCEPBEKey)object).setTryWrongPKCS12Zero(true);
                    ((Mac)object7).init((Key)object, (AlgorithmParameterSpec)object5);
                    ((Mac)object7).update((byte[])object8);
                    object3 = ((Mac)object7).doFinal();
                    object2 = ((DigestInfo)object10).getDigest();
                    int n4 = 0;
                    while (n4 != ((byte[])object3).length) {
                        if (object3[n4] != object2[n4]) {
                            throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                        }
                        ++n4;
                    }
                    bl2 = true;
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("error constructing MAC: " + exception.toString());
            }
        }
        this.keys = new Hashtable();
        this.localIds = new Hashtable();
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.data)) {
            aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(((ASN1OctetString)contentInfo.getContent()).getOctets()));
            object12 = new AuthenticatedSafe((ASN1Sequence)aSN1InputStream.readObject());
            object11 = ((AuthenticatedSafe)object12).getContentInfo();
            int n5 = 0;
            while (n5 != ((ContentInfo[])object11).length) {
                SafeBag safeBag;
                int n6;
                if (object11[n5].getContentType().equals(PKCSObjectIdentifiers.data)) {
                    object10 = new ASN1InputStream(new ByteArrayInputStream(((ASN1OctetString)((ContentInfo)object11[n5]).getContent()).getOctets()));
                    object9 = (ASN1Sequence)((ASN1InputStream)object10).readObject();
                    n6 = 0;
                    while (n6 != ((ASN1Sequence)object9).size()) {
                        safeBag = new SafeBag((ASN1Sequence)((ASN1Sequence)object9).getObjectAt(n6));
                        if (safeBag.getBagId().equals(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag)) {
                            object8 = new EncryptedPrivateKeyInfo((ASN1Sequence)safeBag.getBagValue());
                            object7 = this.unwrapKey(((EncryptedPrivateKeyInfo)object8).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)object8).getEncryptedData(), cArray, bl2);
                            object6 = (PKCS12BagAttributeCarrier)object7;
                            object5 = null;
                            object4 = null;
                            if (safeBag.getBagAttributes() != null) {
                                object3 = safeBag.getBagAttributes().getObjects();
                                while (object3.hasMoreElements()) {
                                    object2 = (ASN1Sequence)object3.nextElement();
                                    DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)((ASN1Sequence)object2).getObjectAt(0);
                                    ASN1Set aSN1Set = (ASN1Set)((ASN1Sequence)object2).getObjectAt(1);
                                    object = null;
                                    if (aSN1Set.size() > 0) {
                                        object = (DERObject)aSN1Set.getObjectAt(0);
                                        object6.setBagAttribute(dERObjectIdentifier, (DEREncodable)object);
                                    }
                                    if (dERObjectIdentifier.equals(PKCSObjectIdentifiers.pkcs_9_at_friendlyName)) {
                                        object5 = ((DERBMPString)object).getString();
                                        this.keys.put(object5, object7);
                                        continue;
                                    }
                                    if (!dERObjectIdentifier.equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                                    object4 = (ASN1OctetString)object;
                                }
                            }
                            if (object4 != null) {
                                object3 = new String(Hex.encode(((ASN1OctetString)object4).getOctets()));
                                if (object5 == null) {
                                    this.keys.put(object3, object7);
                                } else {
                                    this.localIds.put(object5, object3);
                                }
                            } else {
                                bl = true;
                                this.keys.put("unmarked", object7);
                            }
                        } else if (safeBag.getBagId().equals(PKCSObjectIdentifiers.certBag)) {
                            vector.addElement(safeBag);
                        } else {
                            System.out.println("extra in data " + safeBag.getBagId());
                            System.out.println(ASN1Dump.dumpAsString(safeBag));
                        }
                        ++n6;
                    }
                } else if (((ContentInfo)object11[n5]).getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
                    object10 = new EncryptedData((ASN1Sequence)((ContentInfo)object11[n5]).getContent());
                    object9 = this.decryptData(((EncryptedData)object10).getEncryptionAlgorithm(), ((EncryptedData)object10).getContent().getOctets(), cArray, bl2);
                    n6 = 0;
                    while (n6 != ((ASN1Sequence)object9).size()) {
                        ASN1Set aSN1Set;
                        DERObjectIdentifier dERObjectIdentifier;
                        safeBag = new SafeBag((ASN1Sequence)((ASN1Sequence)object9).getObjectAt(n6));
                        if (safeBag.getBagId().equals(PKCSObjectIdentifiers.certBag)) {
                            vector.addElement(safeBag);
                        } else if (safeBag.getBagId().equals(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag)) {
                            object8 = new EncryptedPrivateKeyInfo((ASN1Sequence)safeBag.getBagValue());
                            object7 = this.unwrapKey(((EncryptedPrivateKeyInfo)object8).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)object8).getEncryptedData(), cArray, bl2);
                            object6 = (PKCS12BagAttributeCarrier)object7;
                            object5 = null;
                            object4 = null;
                            object3 = safeBag.getBagAttributes().getObjects();
                            while (object3.hasMoreElements()) {
                                object2 = (ASN1Sequence)object3.nextElement();
                                dERObjectIdentifier = (DERObjectIdentifier)((ASN1Sequence)object2).getObjectAt(0);
                                aSN1Set = (ASN1Set)((ASN1Sequence)object2).getObjectAt(1);
                                object = null;
                                if (aSN1Set.size() > 0) {
                                    object = (DERObject)aSN1Set.getObjectAt(0);
                                    object6.setBagAttribute(dERObjectIdentifier, (DEREncodable)object);
                                }
                                if (dERObjectIdentifier.equals(PKCSObjectIdentifiers.pkcs_9_at_friendlyName)) {
                                    object5 = ((DERBMPString)object).getString();
                                    this.keys.put(object5, object7);
                                    continue;
                                }
                                if (!dERObjectIdentifier.equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                                object4 = (ASN1OctetString)object;
                            }
                            object2 = new String(Hex.encode(((ASN1OctetString)object4).getOctets()));
                            if (object5 == null) {
                                this.keys.put(object2, object7);
                            } else {
                                this.localIds.put(object5, object2);
                            }
                        } else if (safeBag.getBagId().equals(PKCSObjectIdentifiers.keyBag)) {
                            object8 = new PrivateKeyInfo((ASN1Sequence)safeBag.getBagValue());
                            object7 = JDKKeyFactory.createPrivateKeyFromPrivateKeyInfo((PrivateKeyInfo)object8);
                            object6 = (PKCS12BagAttributeCarrier)object7;
                            object5 = null;
                            object4 = null;
                            object3 = safeBag.getBagAttributes().getObjects();
                            while (object3.hasMoreElements()) {
                                object2 = (ASN1Sequence)object3.nextElement();
                                dERObjectIdentifier = (DERObjectIdentifier)((ASN1Sequence)object2).getObjectAt(0);
                                aSN1Set = (ASN1Set)((ASN1Sequence)object2).getObjectAt(1);
                                object = null;
                                if (aSN1Set.size() > 0) {
                                    object = (DERObject)aSN1Set.getObjectAt(0);
                                    object6.setBagAttribute(dERObjectIdentifier, (DEREncodable)object);
                                }
                                if (dERObjectIdentifier.equals(PKCSObjectIdentifiers.pkcs_9_at_friendlyName)) {
                                    object5 = ((DERBMPString)object).getString();
                                    this.keys.put(object5, object7);
                                    continue;
                                }
                                if (!dERObjectIdentifier.equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                                object4 = (ASN1OctetString)object;
                            }
                            object2 = new String(Hex.encode(((ASN1OctetString)object4).getOctets()));
                            if (object5 == null) {
                                this.keys.put(object2, object7);
                            } else {
                                this.localIds.put(object5, object2);
                            }
                        } else {
                            System.out.println("extra in encryptedData " + safeBag.getBagId());
                            System.out.println(ASN1Dump.dumpAsString(safeBag));
                        }
                        ++n6;
                    }
                } else {
                    System.out.println("extra " + ((ContentInfo)object11[n5]).getContentType().getId());
                    System.out.println("extra " + ASN1Dump.dumpAsString(((ContentInfo)object11[n5]).getContent()));
                }
                ++n5;
            }
        }
        this.certs = new Hashtable();
        this.chainCerts = new Hashtable();
        this.keyCerts = new Hashtable();
        int n7 = 0;
        while (n7 != vector.size()) {
            Object object13;
            object11 = (SafeBag)vector.elementAt(n7);
            CertBag certBag = new CertBag((ASN1Sequence)((SafeBag)object11).getBagValue());
            object10 = null;
            try {
                object9 = new ByteArrayInputStream(((ASN1OctetString)certBag.getCertValue()).getOctets());
                object10 = this.certFact.generateCertificate((InputStream)object9);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
            object9 = null;
            String string = null;
            if (((SafeBag)object11).getBagAttributes() != null) {
                object13 = ((SafeBag)object11).getBagAttributes().getObjects();
                while (object13.hasMoreElements()) {
                    object8 = (ASN1Sequence)object13.nextElement();
                    object7 = (DERObjectIdentifier)((ASN1Sequence)object8).getObjectAt(0);
                    object6 = (DERObject)((ASN1Set)((ASN1Sequence)object8).getObjectAt(1)).getObjectAt(0);
                    if (object10 instanceof PKCS12BagAttributeCarrier) {
                        object5 = (PKCS12BagAttributeCarrier)object10;
                        object5.setBagAttribute((DERObjectIdentifier)object7, (DEREncodable)object6);
                    }
                    if (((DERObjectIdentifier)object7).equals(PKCSObjectIdentifiers.pkcs_9_at_friendlyName)) {
                        string = ((DERBMPString)object6).getString();
                        continue;
                    }
                    if (!((DERObjectIdentifier)object7).equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                    object9 = (ASN1OctetString)object6;
                }
            }
            this.chainCerts.put(new CertId(((Certificate)object10).getPublicKey()), object10);
            if (bl) {
                if (this.keyCerts.isEmpty()) {
                    object13 = new String(Hex.encode(this.createSubjectKeyId(((Certificate)object10).getPublicKey()).getKeyIdentifier()));
                    this.keyCerts.put(object13, object10);
                    this.keys.put(object13, this.keys.remove("unmarked"));
                }
            } else {
                if (object9 != null) {
                    object13 = new String(Hex.encode(((ASN1OctetString)object9).getOctets()));
                    this.keyCerts.put(object13, object10);
                }
                if (string != null) {
                    this.certs.put(string, object10);
                }
            }
            ++n7;
        }
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.certs.get(string) != null) {
            throw new KeyStoreException("There is already a certificate with the name " + string + ".");
        }
        this.certs.put(string, certificate);
        this.chainCerts.put(new CertId(certificate.getPublicKey()), certificate);
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (key instanceof PrivateKey && certificateArray == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        if (this.keys.get(string) != null && !key.equals(this.keys.get(string))) {
            throw new KeyStoreException("There is already a key with the name " + string + ".");
        }
        this.keys.put(string, key);
        this.certs.put(string, certificateArray[0]);
        int n = 0;
        while (n != certificateArray.length) {
            this.chainCerts.put(new CertId(certificateArray[n].getPublicKey()), certificateArray[n]);
            ++n;
        }
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new RuntimeException("operation not supported");
    }

    public int engineSize() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.size();
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Enumeration enumeration;
        ASN1Encodable aSN1Encodable;
        ASN1Encodable aSN1Encodable2;
        Object object11;
        Object object12;
        Object object13;
        Object object14;
        Object object15;
        if (cArray == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        ContentInfo[] contentInfoArray = new ContentInfo[2];
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration2 = this.keys.keys();
        while (enumeration2.hasMoreElements()) {
            object15 = new byte[20];
            this.random.nextBytes((byte[])object15);
            object14 = (String)enumeration2.nextElement();
            object13 = (PrivateKey)this.keys.get(object14);
            object12 = new PKCS12PBEParams((byte[])object15, 100);
            object11 = this.wrapKey(KEY_ALGORITHM, (Key)object13, (PKCS12PBEParams)object12, cArray);
            aSN1Encodable2 = new AlgorithmIdentifier(new DERObjectIdentifier(KEY_ALGORITHM), ((ASN1Encodable)object12).getDERObject());
            aSN1Encodable = new EncryptedPrivateKeyInfo((AlgorithmIdentifier)aSN1Encodable2, (byte[])object11);
            boolean bl = false;
            enumeration = new ASN1EncodableVector();
            if (object13 instanceof PKCS12BagAttributeCarrier) {
                Object object16;
                object10 = (PKCS12BagAttributeCarrier)object13;
                object9 = (DERBMPString)object10.getBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName);
                if (object9 == null || !((DERBMPString)object9).getString().equals(object14)) {
                    object10.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, new DERBMPString((String)object14));
                }
                if (object10.getBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId) == null) {
                    object16 = this.engineGetCertificate((String)object14);
                    object10.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, this.createSubjectKeyId(((Certificate)object16).getPublicKey()));
                }
                object16 = object10.getBagAttributeKeys();
                while (object16.hasMoreElements()) {
                    object8 = (DERObjectIdentifier)object16.nextElement();
                    object7 = new ASN1EncodableVector();
                    ((DEREncodableVector)object7).add((DEREncodable)object8);
                    ((DEREncodableVector)object7).add(new DERSet(object10.getBagAttribute((DERObjectIdentifier)object8)));
                    bl = true;
                    ((DEREncodableVector)((Object)enumeration)).add(new DERSequence((DEREncodableVector)object7));
                }
            }
            if (!bl) {
                object10 = new ASN1EncodableVector();
                object9 = this.engineGetCertificate((String)object14);
                ((DEREncodableVector)object10).add(PKCSObjectIdentifiers.pkcs_9_at_localKeyId);
                ((DEREncodableVector)object10).add(new DERSet(this.createSubjectKeyId(((Certificate)object9).getPublicKey())));
                ((DEREncodableVector)((Object)enumeration)).add(new DERSequence((DEREncodableVector)object10));
                object10 = new ASN1EncodableVector();
                ((DEREncodableVector)object10).add(PKCSObjectIdentifiers.pkcs_9_at_friendlyName);
                ((DEREncodableVector)object10).add(new DERSet(new DERBMPString((String)object14)));
                ((DEREncodableVector)((Object)enumeration)).add(new DERSequence((DEREncodableVector)object10));
            }
            object10 = new SafeBag(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag, aSN1Encodable.getDERObject(), new DERSet((DEREncodableVector)((Object)enumeration)));
            aSN1EncodableVector.add((DEREncodable)object10);
        }
        object15 = new ByteArrayOutputStream();
        object14 = new DEROutputStream((OutputStream)object15);
        ((DEROutputStream)object14).writeObject(new DERSequence(aSN1EncodableVector));
        object13 = new BERConstructedOctetString(((ByteArrayOutputStream)object15).toByteArray());
        object12 = new byte[20];
        this.random.nextBytes((byte[])object12);
        object11 = new ASN1EncodableVector();
        aSN1Encodable2 = new PKCS12PBEParams((byte[])object12, 100);
        aSN1Encodable = new AlgorithmIdentifier(new DERObjectIdentifier(CERT_ALGORITHM), aSN1Encodable2.getDERObject());
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            try {
                object10 = (String)enumeration.nextElement();
                object9 = this.engineGetCertificate((String)object10);
                boolean bl = false;
                object8 = new CertBag(PKCSObjectIdentifiers.x509certType, new DEROctetString(((Certificate)object9).getEncoded()));
                object7 = new ASN1EncodableVector();
                if (object9 instanceof PKCS12BagAttributeCarrier) {
                    object6 = (PKCS12BagAttributeCarrier)object9;
                    object5 = (DERBMPString)object6.getBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName);
                    if (object5 == null || !((DERBMPString)object5).getString().equals(object10)) {
                        object6.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, new DERBMPString((String)object10));
                    }
                    if (object6.getBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId) == null) {
                        object6.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, this.createSubjectKeyId(((Certificate)object9).getPublicKey()));
                    }
                    object4 = object6.getBagAttributeKeys();
                    while (object4.hasMoreElements()) {
                        object3 = (DERObjectIdentifier)object4.nextElement();
                        object2 = new ASN1EncodableVector();
                        ((DEREncodableVector)object2).add((DEREncodable)object3);
                        ((DEREncodableVector)object2).add(new DERSet(object6.getBagAttribute((DERObjectIdentifier)object3)));
                        ((DEREncodableVector)object7).add(new DERSequence((DEREncodableVector)object2));
                        bl = true;
                    }
                }
                if (!bl) {
                    object6 = new ASN1EncodableVector();
                    ((DEREncodableVector)object6).add(PKCSObjectIdentifiers.pkcs_9_at_localKeyId);
                    ((DEREncodableVector)object6).add(new DERSet(this.createSubjectKeyId(((Certificate)object9).getPublicKey())));
                    ((DEREncodableVector)object7).add(new DERSequence((DEREncodableVector)object6));
                    object6 = new ASN1EncodableVector();
                    ((DEREncodableVector)object6).add(PKCSObjectIdentifiers.pkcs_9_at_friendlyName);
                    ((DEREncodableVector)object6).add(new DERSet(new DERBMPString((String)object10)));
                    ((DEREncodableVector)object7).add(new DERSequence((DEREncodableVector)object6));
                }
                object6 = new SafeBag(PKCSObjectIdentifiers.certBag, ((ASN1Encodable)object8).getDERObject(), new DERSet((DEREncodableVector)object7));
                ((DEREncodableVector)object11).add((DEREncodable)object6);
                hashtable.put(object9, object9);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            try {
                object10 = (String)enumeration.nextElement();
                object9 = (Certificate)this.certs.get(object10);
                boolean bl = false;
                if (this.keys.get(object10) != null) continue;
                object8 = new CertBag(PKCSObjectIdentifiers.x509certType, new DEROctetString(((Certificate)object9).getEncoded()));
                object7 = new ASN1EncodableVector();
                if (object9 instanceof PKCS12BagAttributeCarrier) {
                    object6 = (PKCS12BagAttributeCarrier)object9;
                    object5 = (DERBMPString)object6.getBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName);
                    if (object5 == null || !((DERBMPString)object5).getString().equals(object10)) {
                        object6.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, new DERBMPString((String)object10));
                    }
                    object4 = object6.getBagAttributeKeys();
                    while (object4.hasMoreElements()) {
                        object3 = (DERObjectIdentifier)object4.nextElement();
                        object2 = new ASN1EncodableVector();
                        ((DEREncodableVector)object2).add((DEREncodable)object3);
                        ((DEREncodableVector)object2).add(new DERSet(object6.getBagAttribute((DERObjectIdentifier)object3)));
                        ((DEREncodableVector)object7).add(new DERSequence((DEREncodableVector)object2));
                        bl = true;
                    }
                }
                if (!bl) {
                    object6 = new ASN1EncodableVector();
                    ((DEREncodableVector)object6).add(PKCSObjectIdentifiers.pkcs_9_at_friendlyName);
                    ((DEREncodableVector)object6).add(new DERSet(new DERBMPString((String)object10)));
                    ((DEREncodableVector)object7).add(new DERSequence((DEREncodableVector)object6));
                }
                object6 = new SafeBag(PKCSObjectIdentifiers.certBag, ((ASN1Encodable)object8).getDERObject(), new DERSet((DEREncodableVector)object7));
                ((DEREncodableVector)object11).add((DEREncodable)object6);
                hashtable.put(object9, object9);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        enumeration = this.chainCerts.keys();
        while (enumeration.hasMoreElements()) {
            try {
                object10 = (CertId)enumeration.nextElement();
                object9 = (Certificate)this.chainCerts.get(object10);
                if (hashtable.get(object9) != null) continue;
                CertBag certBag = new CertBag(PKCSObjectIdentifiers.x509certType, new DEROctetString(((Certificate)object9).getEncoded()));
                object8 = new ASN1EncodableVector();
                if (object9 instanceof PKCS12BagAttributeCarrier) {
                    object7 = (PKCS12BagAttributeCarrier)object9;
                    object6 = object7.getBagAttributeKeys();
                    while (object6.hasMoreElements()) {
                        object5 = (DERObjectIdentifier)object6.nextElement();
                        object4 = new ASN1EncodableVector();
                        ((DEREncodableVector)object4).add((DEREncodable)object5);
                        ((DEREncodableVector)object4).add(new DERSet(object7.getBagAttribute((DERObjectIdentifier)object5)));
                        ((DEREncodableVector)object8).add(new DERSequence((DEREncodableVector)object4));
                    }
                }
                object7 = new SafeBag(PKCSObjectIdentifiers.certBag, certBag.getDERObject(), new DERSet((DEREncodableVector)object8));
                ((DEREncodableVector)object11).add((DEREncodable)object7);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        ((ByteArrayOutputStream)object15).reset();
        object14 = new DEROutputStream((OutputStream)object15);
        ((DEROutputStream)object14).writeObject(new DERSequence((DEREncodableVector)object11));
        ((FilterOutputStream)object14).close();
        object10 = this.encryptData(CERT_ALGORITHM, ((ByteArrayOutputStream)object15).toByteArray(), (PKCS12PBEParams)aSN1Encodable2, cArray);
        object9 = new EncryptedData(PKCSObjectIdentifiers.data, (AlgorithmIdentifier)aSN1Encodable, new BERConstructedOctetString((byte[])object10));
        contentInfoArray[0] = new ContentInfo(PKCSObjectIdentifiers.data, (DEREncodable)object13);
        contentInfoArray[1] = new ContentInfo(PKCSObjectIdentifiers.encryptedData, ((ASN1Encodable)object9).getDERObject());
        AuthenticatedSafe authenticatedSafe = new AuthenticatedSafe(contentInfoArray);
        ((ByteArrayOutputStream)object15).reset();
        object8 = new BEROutputStream((OutputStream)object15);
        ((BEROutputStream)object8).writeObject(authenticatedSafe);
        object7 = ((ByteArrayOutputStream)object15).toByteArray();
        object6 = new ContentInfo(PKCSObjectIdentifiers.data, new BERConstructedOctetString((byte[])object7));
        object5 = new byte[20];
        int n = 100;
        this.random.nextBytes((byte[])object5);
        object3 = ((ASN1OctetString)((ContentInfo)object6).getContent()).getOctets();
        object2 = null;
        try {
            object = Mac.getInstance(X509ObjectIdentifiers.id_SHA1.getId(), "BC");
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(X509ObjectIdentifiers.id_SHA1.getId(), "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec((byte[])object5, n);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            ((Mac)object).init(secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
            ((Mac)object).update((byte[])object3);
            byte[] byArray = ((Mac)object).doFinal();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, new DERNull());
            DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, byArray);
            object2 = new MacData(digestInfo, (byte[])object5, n);
        }
        catch (Exception exception) {
            throw new IOException("error constructing MAC: " + exception.toString());
        }
        object = new Pfx((ContentInfo)object6, (MacData)object2);
        object8 = new BEROutputStream(outputStream);
        ((BEROutputStream)object8).writeObject(object);
    }

    public void setRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    protected PrivateKey unwrapKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, char[] cArray, boolean bl) throws IOException {
        String string = algorithmIdentifier.getObjectId().getId();
        PKCS12PBEParams pKCS12PBEParams = new PKCS12PBEParams((ASN1Sequence)algorithmIdentifier.getParameters());
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        PrivateKey privateKey = null;
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            ((JCEPBEKey)secretKey).setTryWrongPKCS12Zero(bl);
            Cipher cipher = Cipher.getInstance(string, "BC");
            cipher.init(4, (Key)secretKey, pBEParameterSpec);
            privateKey = (PrivateKey)cipher.unwrap(byArray, "", 2);
        }
        catch (Exception exception) {
            throw new IOException("exception unwrapping private key - " + exception.toString());
        }
        return privateKey;
    }

    protected byte[] wrapKey(String string, Key key, PKCS12PBEParams pKCS12PBEParams, char[] cArray) throws IOException {
        byte[] byArray;
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            Cipher cipher = Cipher.getInstance(string, "BC");
            cipher.init(3, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
            byArray = cipher.wrap(key);
        }
        catch (Exception exception) {
            throw new IOException("exception encrypting data - " + exception.toString());
        }
        return byArray;
    }

    private class CertId {
        byte[] id;

        CertId(PublicKey publicKey) {
            this.id = JDKPKCS12KeyStore.this.createSubjectKeyId(publicKey).getKeyIdentifier();
        }

        CertId(byte[] byArray) {
            this.id = byArray;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CertId)) {
                return false;
            }
            CertId certId = (CertId)object;
            if (certId.id.length != this.id.length) {
                return false;
            }
            int n = 0;
            while (n != this.id.length) {
                if (certId.id[n] != this.id[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public int hashCode() {
            int n = this.id[0] & 0xFF;
            int n2 = 1;
            while (n2 != this.id.length - 4) {
                n ^= (this.id[n2] & 0xFF) << 24 | (this.id[n2 + 1] & 0xFF) << 16 | (this.id[n2 + 2] & 0xFF) << 8 | this.id[n2 + 3] & 0xFF;
                ++n2;
            }
            return n;
        }
    }

    public static class BCPKCS12KeyStore
    extends JDKPKCS12KeyStore {
        public BCPKCS12KeyStore() {
            super("BC");
        }
    }

    public static class DefPKCS12KeyStore
    extends JDKPKCS12KeyStore {
        public DefPKCS12KeyStore() {
            super(null);
        }
    }
}

