/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.sasn1;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.sasn1.Asn1InputStream;
import org.bouncycastle.sasn1.Asn1Object;
import org.bouncycastle.sasn1.BerOctetString;
import org.bouncycastle.sasn1.BerSequence;
import org.bouncycastle.sasn1.BerSet;
import org.bouncycastle.sasn1.DefiniteLengthInputStream;
import org.bouncycastle.sasn1.DerOctetString;
import org.bouncycastle.sasn1.DerSequence;
import org.bouncycastle.sasn1.DerSet;
import org.bouncycastle.sasn1.IndefiniteLengthInputStream;

public class Asn1TaggedObject
extends Asn1Object {
    protected Asn1TaggedObject(int n, int n2, InputStream inputStream) {
        super(n, n2, inputStream);
    }

    public Asn1Object getObject(int n, boolean bl) throws IOException {
        if (bl) {
            return new Asn1InputStream(this.getRawContentStream()).readObject();
        }
        switch (n) {
            case 17: {
                if (this.getRawContentStream() instanceof IndefiniteLengthInputStream) {
                    return new BerSet(32, this.getRawContentStream());
                }
                return new DerSet(32, ((DefiniteLengthInputStream)this.getRawContentStream()).toByteArray());
            }
            case 16: {
                if (this.getRawContentStream() instanceof IndefiniteLengthInputStream) {
                    return new BerSequence(32, this.getRawContentStream());
                }
                return new DerSequence(32, ((DefiniteLengthInputStream)this.getRawContentStream()).toByteArray());
            }
            case 4: {
                if (this.getRawContentStream() instanceof IndefiniteLengthInputStream) {
                    return new BerOctetString(32, this.getRawContentStream());
                }
                return new DerOctetString(32, ((DefiniteLengthInputStream)this.getRawContentStream()).toByteArray());
            }
        }
        throw new RuntimeException("implicit tagging not implemented");
    }
}

