/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.sasn1;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.sasn1.Asn1InputStream;
import org.bouncycastle.sasn1.Asn1OctetString;
import org.bouncycastle.sasn1.DerObject;

public class DerOctetString
extends DerObject
implements Asn1OctetString {
    protected DerOctetString(int n, byte[] byArray) {
        super(n, 4, byArray);
    }

    public InputStream getOctetStream() {
        if (this.isConstructed()) {
            return new ConstructedOctetStream(this.getRawContentStream());
        }
        return this.getRawContentStream();
    }

    private class ConstructedOctetStream
    extends InputStream {
        private final Asn1InputStream _aIn;
        private boolean _first = true;
        private InputStream _currentStream;

        ConstructedOctetStream(InputStream inputStream) {
            this._aIn = new Asn1InputStream(inputStream);
        }

        public int read() throws IOException {
            int n;
            if (this._first) {
                DerOctetString derOctetString = (DerOctetString)this._aIn.readObject();
                if (derOctetString == null) {
                    return -1;
                }
                this._first = false;
                this._currentStream = derOctetString.getOctetStream();
            }
            if ((n = this._currentStream.read()) < 0) {
                DerOctetString derOctetString = (DerOctetString)this._aIn.readObject();
                if (derOctetString == null) {
                    this._currentStream = null;
                    return -1;
                }
                this._currentStream = derOctetString.getOctetStream();
                return this._currentStream.read();
            }
            return n;
        }
    }
}

