/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.bpmn.builder;

import java.util.Collection;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.AbstractProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.EventSubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.StartEvent;
import org.camunda.bpm.model.bpmn.instance.SubProcess;
import org.camunda.bpm.model.bpmn.instance.bpmndi.BpmnShape;
import org.camunda.bpm.model.bpmn.instance.dc.Bounds;

public class ProcessBuilder
extends AbstractProcessBuilder<ProcessBuilder> {
    public ProcessBuilder(BpmnModelInstance modelInstance, Process process) {
        super(modelInstance, process, ProcessBuilder.class);
    }

    public StartEventBuilder startEvent() {
        return this.startEvent(null);
    }

    public StartEventBuilder startEvent(String id) {
        StartEvent start = this.createChild(StartEvent.class, id);
        BpmnShape bpmnShape = this.createBpmnShape(start);
        this.setCoordinates(bpmnShape);
        return start.builder();
    }

    public EventSubProcessBuilder eventSubProcess() {
        return this.eventSubProcess(null);
    }

    public EventSubProcessBuilder eventSubProcess(String id) {
        SubProcess subProcess = this.createChild(SubProcess.class, id);
        subProcess.setTriggeredByEvent(true);
        BpmnShape targetBpmnShape = this.createBpmnShape(subProcess);
        this.setEventSubProcessCoordinates(targetBpmnShape);
        this.resizeSubProcess(targetBpmnShape);
        EventSubProcessBuilder eventSubProcessBuilder = new EventSubProcessBuilder(this.modelInstance, subProcess);
        return eventSubProcessBuilder;
    }

    @Override
    protected void setCoordinates(BpmnShape targetBpmnShape) {
        Bounds bounds = targetBpmnShape.getBounds();
        bounds.setX(100.0);
        bounds.setY(100.0);
    }

    protected void setEventSubProcessCoordinates(BpmnShape targetBpmnShape) {
        SubProcess eventSubProcess = (SubProcess)targetBpmnShape.getBpmnElement();
        Bounds targetBounds = targetBpmnShape.getBounds();
        double lowestheight = 0.0;
        Collection allShapes = this.modelInstance.getModelElementsByType(BpmnShape.class);
        for (BpmnShape shape : allShapes) {
            Bounds bounds = shape.getBounds();
            double bottom = bounds.getY() + bounds.getHeight();
            if (!(bottom > lowestheight)) continue;
            lowestheight = bottom;
        }
        Double ycoord = lowestheight + 50.0;
        Double xcoord = 100.0;
        targetBounds.setY(ycoord);
        targetBounds.setX(xcoord);
    }
}

