/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.security.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.webapp.impl.security.auth.Authentication;
import org.camunda.bpm.webapp.impl.security.auth.UserAuthentication;
import org.camunda.bpm.webapp.impl.util.ProcessEngineUtil;

public class AuthenticationService {
    public static final String[] APPS = new String[]{"cockpit", "tasklist", "admin"};
    public static final String APP_WELCOME = "welcome";

    public Authentication createAuthenticate(String engineName, String username) {
        return this.createAuthenticate(engineName, username, null, null);
    }

    public Authentication createAuthenticate(String engineName, String username, List<String> groupIds, List<String> tenantIds) {
        ProcessEngine processEngine = ProcessEngineUtil.lookupProcessEngine(engineName);
        if (processEngine == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Process engine with name " + engineName + " does not exist");
        }
        return this.createAuthenticate(processEngine, username, groupIds, tenantIds);
    }

    public Authentication createAuthenticate(ProcessEngine processEngine, String username, List<String> groupIds, List<String> tenantIds) {
        User user = (User)processEngine.getIdentityService().createUserQuery().userId(username).singleResult();
        String userId = user.getId();
        processEngine.getIdentityService().clearAuthentication();
        if (groupIds == null) {
            groupIds = this.getGroupsOfUser(processEngine, userId);
        }
        if (tenantIds == null) {
            tenantIds = this.getTenantsOfUser(processEngine, userId);
        }
        AuthorizationService authorizationService = processEngine.getAuthorizationService();
        HashSet<String> authorizedApps = new HashSet<String>();
        authorizedApps.add(APP_WELCOME);
        if (processEngine.getProcessEngineConfiguration().isAuthorizationEnabled()) {
            for (String application : APPS) {
                if (!this.isAuthorizedForApp(authorizationService, userId, groupIds, application)) continue;
                authorizedApps.add(application);
            }
        } else {
            Collections.addAll(authorizedApps, APPS);
        }
        UserAuthentication newAuthentication = new UserAuthentication(userId, processEngine.getName());
        newAuthentication.setGroupIds(groupIds);
        newAuthentication.setTenantIds(tenantIds);
        newAuthentication.setAuthorizedApps(authorizedApps);
        return newAuthentication;
    }

    public List<String> getTenantsOfUser(ProcessEngine engine, String userId) {
        List tenants = engine.getIdentityService().createTenantQuery().userMember(userId).includingGroupsOfUser(true).list();
        ArrayList<String> tenantIds = new ArrayList<String>();
        for (Tenant tenant : tenants) {
            tenantIds.add(tenant.getId());
        }
        return tenantIds;
    }

    public List<String> getGroupsOfUser(ProcessEngine engine, String userId) {
        List groups = engine.getIdentityService().createGroupQuery().groupMember(userId).list();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    protected boolean isAuthorizedForApp(AuthorizationService authorizationService, String username, List<String> groupIds, String application) {
        return authorizationService.isUserAuthorized(username, groupIds, (Permission)Permissions.ACCESS, (Resource)Resources.APPLICATION, application);
    }
}

