/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.build;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.codehaus.mojo.build.HgOutputConsumer;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="hgchangeset", defaultPhase=LifecyclePhase.INITIALIZE, requiresProject=true, threadSafe=true)
public class HgChangeSetMojo
extends AbstractMojo {
    @Parameter(property="maven.buildNumber.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="maven.changeSet.scmDirectory", defaultValue="${basedir}")
    private File scmDirectory;
    @Parameter(property="maven.buildNumber.useLastChangeSetInDirectory", defaultValue="false")
    private Boolean useLastChangeSetInDirectory;

    private void checkResult(ScmResult result) throws MojoExecutionException {
        if (!result.isSuccess()) {
            this.getLog().debug((CharSequence)"Provider message:");
            this.getLog().debug((CharSequence)(result.getProviderMessage() == null ? "" : result.getProviderMessage()));
            this.getLog().debug((CharSequence)"Command output:");
            this.getLog().debug((CharSequence)(result.getCommandOutput() == null ? "" : result.getCommandOutput()));
            throw new MojoExecutionException("Command failed." + StringUtils.defaultString((Object)result.getProviderMessage()));
        }
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution.");
            return;
        }
        try {
            String previousChangeSet = this.getChangeSetProperty();
            String previousChangeSetDate = this.getChangeSetDateProperty();
            if (previousChangeSet == null || previousChangeSetDate == null) {
                String changeSet = this.getChangeSet();
                String changeSetDate = this.getChangeSetDate();
                this.getLog().info((CharSequence)("Setting Mercurial Changeset: " + changeSet));
                this.getLog().info((CharSequence)("Setting Mercurial Changeset Date: " + changeSetDate));
                this.setChangeSetProperty(changeSet);
                this.setChangeSetDateProperty(changeSetDate);
            }
        }
        catch (ScmException e) {
            throw new MojoExecutionException("SCM Exception", (Exception)((Object)e));
        }
    }

    protected String getHgCommandOutput(String[] command) throws ScmException, MojoExecutionException {
        HgOutputConsumer consumer = new HgOutputConsumer();
        ScmResult result = HgUtils.execute((HgConsumer)consumer, (File)this.scmDirectory, (String[])command);
        this.checkResult(result);
        return consumer.getOutput();
    }

    protected String getChangeSet() throws ScmException, MojoExecutionException {
        String[] stringArray;
        if (this.useLastChangeSetInDirectory.booleanValue()) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "log";
            stringArray2[1] = "-l1";
            stringArray2[2] = "--template";
            stringArray2[3] = "\"{node|short}\"";
            stringArray = stringArray2;
            stringArray2[4] = ".";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "id";
            stringArray = stringArray3;
            stringArray3[1] = "-i";
        }
        return this.getHgCommandOutput(stringArray);
    }

    protected String getChangeSetDate() throws ScmException, MojoExecutionException {
        String[] stringArray;
        if (this.useLastChangeSetInDirectory.booleanValue()) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "log";
            stringArray2[1] = "-l1";
            stringArray2[2] = "--template";
            stringArray2[3] = "\"{date|isodate}\"";
            stringArray = stringArray2;
            stringArray2[4] = ".";
        } else {
            String[] stringArray3 = new String[5];
            stringArray3[0] = "log";
            stringArray3[1] = "-r";
            stringArray3[2] = ".";
            stringArray3[3] = "--template";
            stringArray = stringArray3;
            stringArray3[4] = "\"{date|isodate}\"";
        }
        return this.getHgCommandOutput(stringArray);
    }

    protected String getChangeSetDateProperty() {
        return this.getProperty("changeSetDate");
    }

    protected String getChangeSetProperty() {
        return this.getProperty("changeSet");
    }

    protected String getProperty(String property) {
        return this.project.getProperties().getProperty(property);
    }

    private void setChangeSetDateProperty(String changeSetDate) {
        this.setProperty("changeSetDate", changeSetDate);
    }

    private void setChangeSetProperty(String changeSet) {
        this.setProperty("changeSet", changeSet);
    }

    private void setProperty(String property, String value) {
        if (value != null) {
            this.project.getProperties().put(property, value);
        }
    }
}

