/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.javageneration;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.jaxb2.AbstractJaxbMojo;
import org.codehaus.mojo.jaxb2.javageneration.AbstractJavaGeneratorMojo;
import org.codehaus.mojo.jaxb2.shared.FileSystemUtilities;
import org.codehaus.mojo.jaxb2.shared.filters.Filter;
import org.codehaus.mojo.jaxb2.shared.filters.Filters;
import org.codehaus.mojo.jaxb2.shared.filters.pattern.PatternFileFilter;

@Mojo(name="xjc", threadSafe=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class XjcMojo
extends AbstractJavaGeneratorMojo {
    public static final String STALE_FILENAME = "xjcStaleFlag";
    public static final String STANDARD_SOURCE_DIRECTORY = "src/main/xsd";
    public static final List<Filter<File>> STANDARD_SOURCE_EXCLUDE_FILTERS;
    public static final String STANDARD_XJB_DIRECTORY = "src/main/xjb";
    public static final List<Filter<File>> STANDARD_XJB_EXCLUDE_FILTERS;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/jaxb", required=true)
    private File outputDirectory;
    @Parameter(required=false)
    private List<String> sources;
    @Parameter(required=false)
    private List<String> xjbSources;
    @Parameter(required=false)
    private List<Filter<File>> xjcSourceExcludeFilters;
    @Parameter(required=false)
    private List<Filter<File>> xjbExcludeFilters;
    @Parameter(property="xjc.skip", defaultValue="false")
    private boolean skipXjc;

    @Override
    protected boolean shouldExecutionBeSkipped() {
        return this.skipXjc;
    }

    @Override
    protected List<URL> getSources() {
        List<Filter<File>> excludePatterns = this.xjcSourceExcludeFilters == null ? STANDARD_SOURCE_EXCLUDE_FILTERS : this.xjcSourceExcludeFilters;
        Filters.initialize(this.getLog(), excludePatterns);
        return FileSystemUtilities.filterFiles(this.getProject().getBasedir(), this.sources, Arrays.asList(STANDARD_SOURCE_DIRECTORY), this.getLog(), "sources", excludePatterns);
    }

    @Override
    protected List<File> getSourceXJBs() {
        List<Filter<File>> excludePatterns = this.xjbExcludeFilters == null ? STANDARD_XJB_EXCLUDE_FILTERS : this.xjbExcludeFilters;
        Filters.initialize(this.getLog(), excludePatterns);
        return FileSystemUtilities.filterFiles(this.getProject().getBasedir(), this.xjbSources, STANDARD_XJB_DIRECTORY, this.getLog(), "xjbSources", excludePatterns);
    }

    @Override
    protected String getStaleFileName() {
        return STALE_FILENAME;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected List<String> getClasspath() throws MojoExecutionException {
        try {
            return this.getProject().getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Could not retrieve Compile classpath.", (Exception)((Object)e));
        }
    }

    @Override
    protected void addGeneratedSourcesToProjectSourceRoot() {
        this.getProject().addCompileSourceRoot(this.getOutputDirectory().getAbsolutePath());
    }

    @Override
    protected void addResource(Resource resource) {
        this.getProject().addResource(resource);
    }

    static {
        ArrayList<Filter<File>> xjbTemp = new ArrayList<Filter<File>>();
        xjbTemp.addAll(AbstractJaxbMojo.STANDARD_EXCLUDE_FILTERS);
        xjbTemp.add(new PatternFileFilter(Arrays.asList("\\.xsd"), true));
        STANDARD_XJB_EXCLUDE_FILTERS = Collections.unmodifiableList(xjbTemp);
        ArrayList<Filter<File>> xsdTemp = new ArrayList<Filter<File>>();
        xsdTemp.addAll(AbstractJaxbMojo.STANDARD_EXCLUDE_FILTERS);
        xsdTemp.add(new PatternFileFilter(Arrays.asList("\\.xjb"), true));
        STANDARD_SOURCE_EXCLUDE_FILTERS = Collections.unmodifiableList(xsdTemp);
    }
}

