/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.schemageneration;

import com.sun.tools.jxc.SchemaGenerator;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.tools.ToolProvider;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.jaxb2.AbstractJaxbMojo;
import org.codehaus.mojo.jaxb2.schemageneration.XsdGeneratorHelper;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.DefaultJavaDocRenderer;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.JavaDocExtractor;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.JavaDocRenderer;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.SearchableDocumentation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.schemaenhancement.SimpleNamespaceResolver;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.schemaenhancement.TransformSchema;
import org.codehaus.mojo.jaxb2.shared.FileSystemUtilities;
import org.codehaus.mojo.jaxb2.shared.arguments.ArgumentBuilder;
import org.codehaus.mojo.jaxb2.shared.environment.EnvironmentFacet;
import org.codehaus.mojo.jaxb2.shared.environment.ToolExecutionEnvironment;
import org.codehaus.mojo.jaxb2.shared.environment.classloading.ThreadContextClassLoaderBuilder;
import org.codehaus.mojo.jaxb2.shared.environment.locale.LocaleFacet;
import org.codehaus.mojo.jaxb2.shared.environment.logging.LoggingHandlerEnvironmentFacet;
import org.codehaus.mojo.jaxb2.shared.filters.Filter;
import org.codehaus.mojo.jaxb2.shared.filters.pattern.PatternFileFilter;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractXsdGeneratorMojo
extends AbstractJaxbMojo {
    public static final Pattern SCHEMAGEN_EMITTED_FILENAME = Pattern.compile("schema\\p{javaDigit}+.xsd");
    public static final JavaDocRenderer STANDARD_JAVADOC_RENDERER = new DefaultJavaDocRenderer();
    public static final List<Filter<File>> STANDARD_BYTECODE_EXCLUDE_FILTERS;
    public static final List<Filter<File>> CLASS_INCLUDE_FILTERS;
    public static final List<String> SYSTEM_TOOLS_CLASSLOADER_PACKAGES;
    private static final int SCHEMAGEN_INCORRECT_OPTIONS = -1;
    private static final int SCHEMAGEN_COMPLETED_OK = 0;
    private static final int SCHEMAGEN_JAXB_ERRORS = 1;
    @Parameter
    private List<TransformSchema> transformSchemas;
    @Parameter(defaultValue="true")
    protected boolean generateEpisode;
    @Parameter(defaultValue="true")
    protected boolean createJavaDocAnnotations;
    @Parameter
    protected JavaDocRenderer javaDocRenderer;
    @Parameter(defaultValue="true")
    protected boolean clearOutputDir;

    @Override
    protected boolean shouldExecutionBeSkipped() {
        boolean toReturn = false;
        if ("pom".equalsIgnoreCase(this.getProject().getPackaging())) {
            this.warnAboutIncorrectPluginConfiguration("packaging", "POM-packaged projects should not generate XSDs.");
            toReturn = true;
        }
        if (this.getSources().isEmpty()) {
            this.warnAboutIncorrectPluginConfiguration("sources", "At least one Java Source file has to be included.");
            toReturn = true;
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isReGenerationRequired() {
        boolean stale;
        File staleFile = this.getStaleFile();
        String debugPrefix = "StaleFile [" + FileSystemUtilities.getCanonicalPath(staleFile) + "]";
        boolean bl = stale = !staleFile.exists();
        if (stale) {
            this.getLog().debug((CharSequence)(debugPrefix + " not found. XML Schema (re-)generation required."));
        } else {
            List<URL> sources = this.getSources();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(debugPrefix + " found. Checking timestamps on source Java " + "files to determine if XML Schema (re-)generation is required."));
            }
            long staleFileLastModified = staleFile.lastModified();
            for (URL current : sources) {
                URLConnection sourceFileConnection;
                try {
                    sourceFileConnection = current.openConnection();
                    sourceFileConnection.connect();
                }
                catch (Exception e) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Could not open a sourceFileConnection to [" + current + "]"), (Throwable)e);
                    }
                    stale = true;
                    break;
                }
                try {
                    if (sourceFileConnection.getLastModified() <= staleFileLastModified) continue;
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)(current.toString() + " is newer than the stale flag file."));
                    }
                    stale = true;
                }
                finally {
                    if (!(sourceFileConnection instanceof HttpURLConnection)) continue;
                    ((HttpURLConnection)sourceFileConnection).disconnect();
                }
            }
        }
        return stale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean performExecution() throws MojoExecutionException, MojoFailureException {
        boolean updateStaleFileTimestamp = false;
        ToolExecutionEnvironment environment = null;
        try {
            boolean reCreateEpisodeFileParentDirectory;
            ClassRealm localRealm = (ClassRealm)((Object)((Object)this)).getClass().getClassLoader();
            for (String current : SYSTEM_TOOLS_CLASSLOADER_PACKAGES) {
                localRealm.importFrom(ToolProvider.getSystemToolClassLoader(), current);
            }
            ThreadContextClassLoaderBuilder classLoaderBuilder = ThreadContextClassLoaderBuilder.createFor(((Object)((Object)this)).getClass(), this.getLog(), this.getEncoding(false)).addPaths(this.getClasspath()).addPaths(this.getProject().getCompileSourceRoots());
            LocaleFacet localeFacet = this.locale == null ? null : LocaleFacet.createFor(this.locale, this.getLog());
            environment = new ToolExecutionEnvironment(this.getLog(), classLoaderBuilder, LoggingHandlerEnvironmentFacet.create(this.getLog(), ((Object)((Object)this)).getClass(), this.getEncoding(false)), localeFacet);
            String projectBasedirPath = FileSystemUtilities.getCanonicalPath(this.getProject().getBasedir());
            if (this.extraFacets != null) {
                for (EnvironmentFacet current : this.extraFacets) {
                    environment.add(current);
                }
            }
            environment.setup();
            List<URL> sources = this.getSources();
            String[] schemaGenArguments = this.getSchemaGenArguments(environment.getClassPathAsArgument(), "sun-jaxb.episode", sources);
            FileSystemUtilities.createDirectory(this.getOutputDirectory(), this.clearOutputDir);
            FileSystemUtilities.createDirectory(this.getWorkDirectory(), this.clearOutputDir);
            boolean bl = reCreateEpisodeFileParentDirectory = this.generateEpisode && this.clearOutputDir;
            if (reCreateEpisodeFileParentDirectory) {
                this.getEpisodeFile("sun-jaxb.episode");
            }
            try {
                boolean performPostProcessing;
                int result = SchemaGenerator.run((String[])schemaGenArguments, (ClassLoader)Thread.currentThread().getContextClassLoader());
                if (-1 == result) {
                    this.printSchemaGenCommandAndThrowException(projectBasedirPath, sources, schemaGenArguments, result, null);
                } else if (1 == result) {
                    throw new MojoExecutionException("JAXB errors arose while SchemaGen compiled sources to XML.");
                }
                List<Filter<File>> exclusionFilters = PatternFileFilter.createIncludeFilterList(this.getLog(), "\\.class");
                List<File> toCopy = FileSystemUtilities.resolveRecursively(Arrays.asList(this.getWorkDirectory()), exclusionFilters, this.getLog());
                for (File current : toCopy) {
                    String currentPath = FileSystemUtilities.getCanonicalPath(current.getAbsoluteFile());
                    File target = new File(this.getOutputDirectory(), FileSystemUtilities.relativize(currentPath, this.getWorkDirectory()));
                    FileSystemUtilities.createDirectory(target.getParentFile(), false);
                    FileUtils.copyFile((File)current, (File)target);
                }
                boolean bl2 = performPostProcessing = this.createJavaDocAnnotations || this.transformSchemas != null;
                if (performPostProcessing) {
                    Map<String, SimpleNamespaceResolver> resolverMap = XsdGeneratorHelper.getFileNameToResolverMap(this.getOutputDirectory());
                    if (this.createJavaDocAnnotations) {
                        if (this.getLog().isInfoEnabled()) {
                            this.getLog().info((CharSequence)"XSD post-processing: Adding JavaDoc annotations in generated XSDs.");
                        }
                        ArrayList<File> fileSources = new ArrayList<File>();
                        for (URL current : sources) {
                            if (!"file".equalsIgnoreCase(current.getProtocol())) continue;
                            File toAdd = new File(current.getPath());
                            if (toAdd.exists()) {
                                fileSources.add(toAdd);
                                continue;
                            }
                            if (!this.getLog().isWarnEnabled()) continue;
                            this.getLog().warn((CharSequence)("Ignoring URL [" + current + "] as it is a nonexistent file."));
                        }
                        List<File> files = FileSystemUtilities.resolveRecursively(fileSources, null, this.getLog());
                        JavaDocExtractor extractor = new JavaDocExtractor(this.getLog()).addSourceFiles(files);
                        SearchableDocumentation javaDocs = extractor.process();
                        JavaDocRenderer renderer = this.javaDocRenderer == null ? STANDARD_JAVADOC_RENDERER : this.javaDocRenderer;
                        int numProcessedFiles = XsdGeneratorHelper.insertJavaDocAsAnnotations(this.getLog(), this.getOutputDirectory(), javaDocs, renderer);
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().info((CharSequence)("XSD post-processing: " + numProcessedFiles + " files processed."));
                        }
                    }
                    if (this.transformSchemas != null) {
                        if (this.getLog().isInfoEnabled()) {
                            this.getLog().info((CharSequence)"XSD post-processing: Renaming and converting XSDs.");
                        }
                        XsdGeneratorHelper.replaceNamespacePrefixes(resolverMap, this.transformSchemas, this.getLog(), this.getOutputDirectory());
                        XsdGeneratorHelper.renameGeneratedSchemaFiles(resolverMap, this.transformSchemas, this.getLog(), this.getOutputDirectory());
                    }
                }
            }
            catch (MojoExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                Throwable current = e;
                while (current.getCause() != null) {
                    current = current.getCause();
                }
                this.getLog().error((CharSequence)"Execution failed.");
                StringBuilder rootCauseBuilder = new StringBuilder();
                rootCauseBuilder.append("\n");
                rootCauseBuilder.append("[Exception]: " + current.getClass().getName() + "\n");
                rootCauseBuilder.append("[Message]: " + current.getMessage() + "\n");
                for (StackTraceElement el : current.getStackTrace()) {
                    rootCauseBuilder.append("         " + el.toString()).append("\n");
                }
                this.getLog().error((CharSequence)rootCauseBuilder.toString().replaceAll("[\r\n]+", "\n"));
                this.printSchemaGenCommandAndThrowException(projectBasedirPath, sources, schemaGenArguments, -1, current);
            }
            this.getBuildContext().refresh(this.getOutputDirectory());
            updateStaleFileTimestamp = true;
        }
        finally {
            if (environment != null) {
                environment.restore();
            }
        }
        return updateStaleFileTimestamp;
    }

    protected abstract File getWorkDirectory();

    protected abstract List<URL> getCompiledClassNames();

    @Override
    protected abstract List<URL> getSources();

    private String[] getSchemaGenArguments(String classPath, String episodeFileNameOrNull, List<URL> sources) throws MojoExecutionException {
        ArgumentBuilder builder = new ArgumentBuilder();
        builder.withNamedArgument("encoding", this.getEncoding(true));
        builder.withNamedArgument("d", this.getWorkDirectory().getAbsolutePath());
        builder.withNamedArgument("classpath", classPath);
        if (episodeFileNameOrNull != null) {
            String episodeFileArgument;
            File episodeFile = this.getEpisodeFile(episodeFileNameOrNull);
            String canonicalPath = FileSystemUtilities.getCanonicalPath(episodeFile);
            try {
                episodeFileArgument = URLDecoder.decode(canonicalPath, this.getEncoding(false));
            }
            catch (UnsupportedEncodingException e) {
                throw new MojoExecutionException("Could not URLDecoder.decode File path [" + canonicalPath + "]", (Exception)e);
            }
            builder.withNamedArgument("episode", episodeFileArgument);
        }
        try {
            builder.withPreCompiledArguments(this.getSchemaGeneratorSourceFiles(sources));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not compile source paths for the SchemaGenerator", (Exception)e);
        }
        return this.logAndReturnToolArguments(builder.build(), "SchemaGen");
    }

    private List<String> getSchemaGeneratorSourceFiles(List<URL> sources) throws IOException, MojoExecutionException {
        TreeMap<String, String> className2SourcePath = new TreeMap<String, String>();
        File baseDir = this.getProject().getBasedir();
        File userDir = new File(System.getProperty("user.dir"));
        String encoding = this.getEncoding(true);
        for (URL current : sources) {
            File sourceCodeFile = FileSystemUtilities.getFileFor(current, encoding);
            String relativePath = FileSystemUtilities.relativize(FileSystemUtilities.getCanonicalPath(sourceCodeFile), userDir);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("SourceCodeFile [" + FileSystemUtilities.getCanonicalPath(sourceCodeFile) + "] and userDir [" + FileSystemUtilities.getCanonicalPath(userDir) + "] ==> relativePath: " + relativePath + ". (baseDir: " + FileSystemUtilities.getCanonicalPath(baseDir) + "]"));
            }
            JavaProjectBuilder builder = new JavaProjectBuilder();
            builder.setEncoding(encoding);
            if (sourceCodeFile.getName().trim().equalsIgnoreCase("package-info.java")) {
                builder.addSource(current);
                Collection packages = builder.getPackages();
                if (packages.size() != 1) {
                    throw new MojoExecutionException("Exactly one package should be present in file [" + sourceCodeFile.getPath() + "]");
                }
                JavaPackage javaPackage = (JavaPackage)packages.iterator().next();
                className2SourcePath.put("package-info for (" + javaPackage.getName() + ")", relativePath);
                continue;
            }
            builder.addSource(sourceCodeFile);
            for (JavaSource currentJavaSource : builder.getSources()) {
                for (JavaClass currentJavaClass : currentJavaSource.getClasses()) {
                    String className = currentJavaClass.getFullyQualifiedName();
                    if (className2SourcePath.containsKey(className)) {
                        if (!this.getLog().isWarnEnabled()) continue;
                        this.getLog().warn((CharSequence)("Already mapped. Source class [" + className + "] within [" + (String)className2SourcePath.get(className) + "]. Not overwriting with [" + relativePath + "]"));
                        continue;
                    }
                    className2SourcePath.put(className, relativePath);
                }
            }
        }
        if (this.getLog().isDebugEnabled()) {
            int size = className2SourcePath.size();
            this.getLog().debug((CharSequence)("[ClassName-2-SourcePath Map (size: " + size + ")] ..."));
            int i = 0;
            for (Map.Entry current : className2SourcePath.entrySet()) {
                this.getLog().debug((CharSequence)("  " + ++i + "/" + size + ": [" + (String)current.getKey() + "]: " + (String)current.getValue()));
            }
            this.getLog().debug((CharSequence)"... End [ClassName-2-SourcePath Map]");
        }
        ArrayList<String> toReturn = new ArrayList<String>(className2SourcePath.values());
        Collections.sort(toReturn);
        return toReturn;
    }

    private void printSchemaGenCommandAndThrowException(String projectBasedirPath, List<URL> sources, String[] schemaGenArguments, int result, Throwable cause) throws MojoExecutionException {
        StringBuilder errorMsgBuilder = new StringBuilder();
        errorMsgBuilder.append("\n+=================== [SchemaGenerator Error '" + (result == -1 ? "<unknown>" : Integer.valueOf(result)) + "']\n");
        errorMsgBuilder.append("|\n");
        errorMsgBuilder.append("| SchemaGen did not complete its operation correctly.\n");
        errorMsgBuilder.append("|\n");
        errorMsgBuilder.append("| To re-create the error (and get a proper error message), cd to:\n");
        errorMsgBuilder.append("| ").append(projectBasedirPath).append("\n");
        errorMsgBuilder.append("| ... and fire the following on a command line/in a shell:\n");
        errorMsgBuilder.append("|\n");
        StringBuilder builder = new StringBuilder("schemagen ");
        for (String current : schemaGenArguments) {
            builder.append(current).append(" ");
        }
        errorMsgBuilder.append("| " + builder.toString() + "\n");
        errorMsgBuilder.append("|\n");
        errorMsgBuilder.append("| The following source files should be processed by schemagen:\n");
        for (int i = 0; i < sources.size(); ++i) {
            errorMsgBuilder.append("| " + i + ": ").append(sources.get(i).toString()).append("\n");
        }
        errorMsgBuilder.append("|\n");
        errorMsgBuilder.append("+=================== [End SchemaGenerator Error]\n");
        String msg = errorMsgBuilder.toString().replaceAll("[\r\n]+", "\n");
        if (cause != null) {
            throw new MojoExecutionException(msg, cause);
        }
        throw new MojoExecutionException(msg);
    }

    static {
        SYSTEM_TOOLS_CLASSLOADER_PACKAGES = Arrays.asList("com.sun.source.util", "com.sun.source.tree");
        ArrayList<Filter<File>> schemagenTmp = new ArrayList<Filter<File>>();
        schemagenTmp.addAll(AbstractJaxbMojo.STANDARD_EXCLUDE_FILTERS);
        schemagenTmp.add(new PatternFileFilter(Arrays.asList("\\.java", "\\.scala", "\\.mdo"), false));
        STANDARD_BYTECODE_EXCLUDE_FILTERS = Collections.unmodifiableList(schemagenTmp);
        CLASS_INCLUDE_FILTERS = new ArrayList<Filter<File>>();
        CLASS_INCLUDE_FILTERS.add(new PatternFileFilter(Arrays.asList("\\.class"), true));
    }
}

