/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xmlbeans;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:xmlbeans-maven-plugin:2.3.3", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven XML Beans Plugin", 0);
        this.append(sb, "Runs the xmlbeans parser/code generator against schemas in files and dependent jars.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "xmlbeans:help", 0);
            this.append(sb, "Display help information on xmlbeans-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0xmlbeans:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "xmlbeans".equals(this.goal)) {
            this.append(sb, "xmlbeans:xmlbeans", 0);
            this.append(sb, "A Maven 2 plugin which parses xsd files and produces a corresponding object model based on the Apache XML Beans parser.\n\n\nThe plugin produces two sets of output files referred to as generated sources and generated classes. The former is then compiled to the build outputDirectory. The latter is generated in this directory.\n\n\nNote that the descriptions for the goal's parameters have been blatently copied from http://xmlbeans.apache.org/docs/2.0.0/guide/antXmlbean.html for convenience.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "catalogLocation (Default: ${basedir}/src/main/catalog/resolver-catalog.xml)", 2);
                this.append(sb, "The location of the catalog used to resolve xml entities.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classGenerationDirectory (Default: ${project.build.directory}/generated-classes/xmlbeans)", 2);
                this.append(sb, "Set a location to generate CLASS files into.", 3);
                this.append(sb, "", 0);
                this.append(sb, "compiler", 2);
                this.append(sb, "The compiler implementation to use. If this attribute is not set, the value of the build.compiler property, if set, will be used. Otherwise, the default compiler for the current VM will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "Indicates whether source should be compiled with debug information; defaults to off. If set to off, -g:none will be passed on the command line for compilers that support it (for other compilers, no command line argument will be used). If set to true, the value of the debug level attribute determines the command line argument.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultXmlConfigDir (Default: ${basedir}/src/main/xsdconfig)", 2);
                this.append(sb, "Default xmlConfigs directory. If no xmlConfigs list is specified, this one is checked automatically.", 3);
                this.append(sb, "", 0);
                this.append(sb, "download (Default: false)", 2);
                this.append(sb, "Set to true to permit the compiler to download URLs for imports and includes. Defaults to false, meaning all imports and includes must be copied locally.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedSchemaDirectory (Default: ${project.build.directory}/xmlbeans-xsds)", 2);
                this.append(sb, "The directory where .xsd's pulled from xsdJars will be stored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaSource", 2);
                this.append(sb, "Returns the javasource parameter which specifies an option to the XmlBeans code generator.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jaxb (Default: false)", 2);
                this.append(sb, "Todo: Unkown use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mdefNamespaces", 2);
                this.append(sb, "Define a set of Namespaces for which to ignore duplicate errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "memoryInitialSize", 2);
                this.append(sb, "The initial size of the memory for the underlying VM, if javac is run externally; ignored otherwise. Defaults to the standard VM memory setting. (Examples: 83886080, 81920k, or 80m)", 3);
                this.append(sb, "", 0);
                this.append(sb, "memoryMaximumSize", 2);
                this.append(sb, "The maximum size of the memory for the underlying VM, if javac is run externally; ignored otherwise. Defaults to the standard VM memory setting. (Examples: 83886080, 81920k, or 80m)", 3);
                this.append(sb, "", 0);
                this.append(sb, "noAnn (Default: false)", 2);
                this.append(sb, "Ignore annotations", 3);
                this.append(sb, "", 0);
                this.append(sb, "noJavac (Default: false)", 2);
                this.append(sb, "Don't compile the generated source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noPvr (Default: false)", 2);
                this.append(sb, "Do not enforce the particle valid (restriction) rule.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noUpa (Default: false)", 2);
                this.append(sb, "Do not enforce the unique particle attribution rule.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noVDoc (Default: false)", 2);
                this.append(sb, "do not validate documentation elements", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputJar", 2);
                this.append(sb, "Define the name of the jar file created. For instance, 'myXMLBean.jar' will output the results of this task into a jar with the same name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "quiet (Default: true)", 2);
                this.append(sb, "Supress the normal amount of console output.", 3);
                this.append(sb, "", 0);
                this.append(sb, "schemaDirectory (Default: ${basedir}/src/main/xsd)", 2);
                this.append(sb, "The directory where .xsd files are to be found.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceGenerationDirectory (Default: ${project.build.directory}/generated-sources/xmlbeans)", 2);
                this.append(sb, "Set a location to generate JAVA files into.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceSchemas", 2);
                this.append(sb, "A List of source schema files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleFile (Default: ${project.build.directory}/generated-sources/xmlbeans/.staleFlag)", 2);
                this.append(sb, "The location of the flag file used to determine if the output is stale.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Controls the amount of build message output.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlConfigs", 2);
                this.append(sb, "Configuration files used by the object generator. For more information about the format of these files, see Todo.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xsdJars", 2);
                this.append(sb, "List of artifacts whose xsds need to be compiled.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "xmlbeans-test".equals(this.goal)) {
            this.append(sb, "xmlbeans:xmlbeans-test", 0);
            this.append(sb, "A Maven 2 plugin which parses xsd files and produces a corresponding object model based on the Apache XML Beans parser.\n\n\nThe plugin produces two sets of output files referred to as generated sources and generated classes. The former is then compiled to the build outputDirectory. The latter is generated in this directory.\n\n\nNote that the descriptions for the goal's parameters have been blatently copied from http://xmlbeans.apache.org/docs/2.0.0/guide/antXmlbean.html for convenience.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "catalogLocation (Default: ${basedir}/src/main/catalog/resolver-catalog.xml)", 2);
                this.append(sb, "The location of the catalog used to resolve xml entities.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classGenerationDirectory (Default: ${project.build.directory}/generated-classes/test-xmlbeans)", 2);
                this.append(sb, "Set a location to generate CLASS files into.", 3);
                this.append(sb, "", 0);
                this.append(sb, "compiler", 2);
                this.append(sb, "The compiler implementation to use. If this attribute is not set, the value of the build.compiler property, if set, will be used. Otherwise, the default compiler for the current VM will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "Indicates whether source should be compiled with debug information; defaults to off. If set to off, -g:none will be passed on the command line for compilers that support it (for other compilers, no command line argument will be used). If set to true, the value of the debug level attribute determines the command line argument.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultXmlConfigDir (Default: ${basedir}/src/test/xsdconfig)", 2);
                this.append(sb, "Default xmlConfigs directory. If no xmlConfigs list is specified, this one is checked automatically.", 3);
                this.append(sb, "", 0);
                this.append(sb, "download (Default: false)", 2);
                this.append(sb, "Set to true to permit the compiler to download URLs for imports and includes. Defaults to false, meaning all imports and includes must be copied locally.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedSchemaDirectory (Default: ${project.build.directory}/test-xmlbeans-xsds)", 2);
                this.append(sb, "The directory where .xsd's pulled from xsdJars will be stored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaSource", 2);
                this.append(sb, "Returns the javasource parameter which specifies an option to the XmlBeans code generator.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jaxb (Default: false)", 2);
                this.append(sb, "Todo: Unkown use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mdefNamespaces", 2);
                this.append(sb, "Define a set of Namespaces for which to ignore duplicate errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "memoryInitialSize", 2);
                this.append(sb, "The initial size of the memory for the underlying VM, if javac is run externally; ignored otherwise. Defaults to the standard VM memory setting. (Examples: 83886080, 81920k, or 80m)", 3);
                this.append(sb, "", 0);
                this.append(sb, "memoryMaximumSize", 2);
                this.append(sb, "The maximum size of the memory for the underlying VM, if javac is run externally; ignored otherwise. Defaults to the standard VM memory setting. (Examples: 83886080, 81920k, or 80m)", 3);
                this.append(sb, "", 0);
                this.append(sb, "noAnn (Default: false)", 2);
                this.append(sb, "Ignore annotations", 3);
                this.append(sb, "", 0);
                this.append(sb, "noJavac (Default: false)", 2);
                this.append(sb, "Don't compile the generated source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noPvr (Default: false)", 2);
                this.append(sb, "Do not enforce the particle valid (restriction) rule.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noUpa (Default: false)", 2);
                this.append(sb, "Do not enforce the unique particle attribution rule.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noVDoc (Default: false)", 2);
                this.append(sb, "do not validate documentation elements", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputJar", 2);
                this.append(sb, "Define the name of the jar file created. For instance, 'myXMLBean.jar' will output the results of this task into a jar with the same name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "quiet (Default: true)", 2);
                this.append(sb, "Supress the normal amount of console output.", 3);
                this.append(sb, "", 0);
                this.append(sb, "schemaDirectory (Default: ${basedir}/src/test/xsd)", 2);
                this.append(sb, "The directory where .xsd files are to be found.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceGenerationDirectory (Default: ${project.build.directory}/generated-sources/test-xmlbeans)", 2);
                this.append(sb, "Set a location to generate JAVA files into.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceSchemas", 2);
                this.append(sb, "A List of source schema files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleFile (Default: ${project.build.directory}/generated-sources/test-xmlbeans/.staleFlag)", 2);
                this.append(sb, "The location of the flag file used to determine if the output is stale.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testXsdJars", 2);
                this.append(sb, "List of artifacts whose xsds need to be compiled.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Controls the amount of build message output.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlConfigs", 2);
                this.append(sb, "Configuration files used by the object generator. For more information about the format of these files, see Todo.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

