/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.quickstart.QuickStartConfiguration;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;

public class MavenQuickStartConfiguration
extends QuickStartConfiguration {
    private static final Logger LOG = Log.getLogger(QuickStartConfiguration.class);

    public void preConfigure(WebAppContext context) throws Exception {
        if (context.getBaseResource() == null) {
            throw new IllegalStateException("No location for webapp");
        }
        Resource quickStartWebXml = ((JettyWebAppContext)context).getQuickStartWebDescriptor();
        LOG.debug("quickStartWebXml={}", new Object[]{quickStartWebXml});
        context.getMetaData().setWebXml(quickStartWebXml);
    }

    public void configure(WebAppContext context) throws Exception {
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getClassPathFiles() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting up classpath ...", new Object[0]);
            }
            for (File classPathFile : jwac.getClassPathFiles()) {
                ((WebAppClassLoader)context.getClassLoader()).addClassPath(classPathFile.getCanonicalPath());
            }
        }
        super.configure(context);
        String[] existingServerClasses = context.getServerClasses();
        String[] newServerClasses = new String[2 + (existingServerClasses == null ? 0 : existingServerClasses.length)];
        newServerClasses[0] = "org.apache.maven.";
        newServerClasses[1] = "org.codehaus.plexus.";
        System.arraycopy(existingServerClasses, 0, newServerClasses, 2, existingServerClasses.length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Server classes:", new Object[0]);
            for (int i = 0; i < newServerClasses.length; ++i) {
                LOG.debug(newServerClasses[i], new Object[0]);
            }
        }
        context.setServerClasses(newServerClasses);
    }

    public void deconfigure(WebAppContext context) throws Exception {
        if (!context.isPersistTempDirectory()) {
            Resource originalBases = (Resource)context.getAttribute("org.eclipse.jetty.resources.originalBases");
            String originalBaseStr = originalBases.toString();
            Resource res = context.getBaseResource();
            if (res instanceof ResourceCollection) {
                for (Resource r : ((ResourceCollection)res).getResources()) {
                    if (originalBaseStr.contains(r.toString())) continue;
                    IO.delete((File)r.getFile());
                }
            }
        }
    }
}

