/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho;

import java.util.Objects;

public class SystemCapability {
    private final Type type;
    private final String name;
    private final String version;

    public SystemCapability(Type type, String name, String version) {
        this.type = type;
        this.name = name;
        this.version = version;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.version});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SystemCapability)) return false;
        SystemCapability other = (SystemCapability)obj;
        if (!Objects.equals((Object)this.type, (Object)other.type)) return false;
        if (!Objects.equals(this.name, other.name)) return false;
        if (!Objects.equals(this.version, other.version)) return false;
        return true;
    }

    public static enum Type {
        JAVA_PACKAGE,
        OSGI_EE;

    }
}

